/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.Common;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AirBoxRender {
    public static Object2IntOpenHashMap<BlockEntity> cachedBE = new Object2IntOpenHashMap();

    public static void tick() {
        if (!CCG.CONFIG.goggles.renderBox) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            cachedBE.clear();
            return;
        }
        if (mc.isPaused() || mc.screen != null) {
            return;
        }
        BlockEntity be = Common.getSelectedBE();
        if (be instanceof EncasedFanBlockEntity || be instanceof NozzleBlockEntity) {
            cachedBE.put((Object)be, 120);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.object2IntEntrySet().removeIf(entry -> {
            BlockEntity blockEntity = (BlockEntity)entry.getKey();
            int newValue = entry.getIntValue() - 1;
            entry.setValue(newValue);
            if (!blockEntity.isRemoved()) {
                BlockEntity blockEntity2 = blockEntity;
                Objects.requireNonNull(blockEntity2);
                BlockEntity selector0$temp = blockEntity2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EncasedFanBlockEntity.class, NozzleBlockEntity.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        EncasedFanBlockEntity efbe = (EncasedFanBlockEntity)selector0$temp;
                        AirBoxRender.render(efbe);
                        break;
                    }
                    case 1: {
                        NozzleBlockEntity nbe = (NozzleBlockEntity)selector0$temp;
                        AirBoxRender.render(nbe);
                        break;
                    }
                }
            }
            return newValue <= 0;
        });
    }

    public static int getColor(boolean pushing) {
        return pushing ? 14532966 : 8375776;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static void render(@NotNull EncasedFanBlockEntity efbe) {
        AirCurrent airCurrent = efbe.airCurrent;
        int color = AirBoxRender.getColor(airCurrent.pushing);
        AABB bounds = airCurrent.bounds;
        Outliner.getInstance().showAABB((Object)("FanAirBox" + String.valueOf(efbe.getBlockPos())), bounds).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = (int)(airCurrent.maxDistance / 3.0f);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = AirBoxRender.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)airCurrent.maxDistance * offset;
            Direction.Axis axis = airCurrent.direction.getAxis();
            double min = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.minX;
                case Direction.Axis.Y -> bounds.minY;
                case Direction.Axis.Z -> bounds.minZ;
            };
            double max = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.maxX;
                case Direction.Axis.Y -> bounds.maxY;
                case Direction.Axis.Z -> bounds.maxZ;
            };
            double pos = airCurrent.pushing == airCurrent.direction.getAxisDirection().getStep() > 0 ? min + offsetDistance : max - offsetDistance;
            AABB flowBound = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new AABB(pos, bounds.minY, bounds.minZ, pos, bounds.maxY, bounds.maxZ);
                case Direction.Axis.Y -> new AABB(bounds.minX, pos, bounds.minZ, bounds.maxX, pos, bounds.maxZ);
                case Direction.Axis.Z -> new AABB(bounds.minX, bounds.minY, pos, bounds.maxX, bounds.maxY, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(efbe.getBlockPos()) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            Outliner.getInstance().chaseAABB((Object)id, flowBound).lineWidth(0.0625f).colored(color);
        }
    }

    public static void render(@NotNull NozzleBlockEntity nbe) {
        Vec3 center = VecHelper.getCenterOf((Vec3i)nbe.getBlockPos());
        int color = AirBoxRender.getColor(nbe.pushing);
        Outliner.getInstance().showAABB((Object)("NozzleAirBox" + String.valueOf(nbe.getBlockPos())), new AABB(center, center).inflate((double)(nbe.range / 2.0f))).colored(color);
        int numberOfFlowBoxes = (int)(nbe.range / 3.0f);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = AirBoxRender.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(nbe.getBlockPos()) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            double radius = nbe.pushing ? offset * (double)nbe.range / 2.0 : (1.0 - offset) * (double)nbe.range / 2.0;
            AABB flowBound = new AABB(center, center).inflate(radius);
            Outliner.getInstance().chaseAABB((Object)id, flowBound).lineWidth(0.0625f).colored(color);
        }
    }
}

