/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CCGLang
extends Lang {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static LangBuilder builder() {
        return new LangBuilder("create_cyber_goggles");
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static LangBuilder configBuilder() {
        return new LangBuilder("text.autoconfig.create_cyber_goggles");
    }

    @NotNull
    public static LangBuilder translate(String langKey, Object ... args) {
        return CCGLang.builder().translate(langKey, args);
    }

    @NotNull
    public static LangBuilder translate(ChatFormatting format, String langKey, Object ... args) {
        return CCGLang.translate(langKey, args).style(format);
    }

    @NotNull
    public static LangBuilder text(String text) {
        return CCGLang.builder().text(text);
    }

    @NotNull
    public static LangBuilder text(ChatFormatting format, String literalText) {
        return CCGLang.builder().text(format, literalText);
    }

    @NotNull
    public static LangBuilder number(double number) {
        return CCGLang.text(LangNumberFormat.format((double)number));
    }

    @NotNull
    public static LangBuilder number(int number) {
        return CCGLang.text(String.valueOf(number));
    }

    @NotNull
    public static LangBuilder number(ChatFormatting format, int number) {
        return CCGLang.text(format, String.valueOf(number));
    }

    @NotNull
    public static LangBuilder progress(float progress, int totalBars) {
        int filledBars = (int)(progress * (float)totalBars);
        return CCGLang.text(ChatFormatting.GREEN, "|".repeat(filledBars)).text(ChatFormatting.GRAY, "|".repeat(totalBars - filledBars));
    }

    @NotNull
    public static LangBuilder fraction(int current, int total) {
        return CCGLang.number(current).color(CCGUtil.getGradientColor((float)current / (float)total)).text(ChatFormatting.GRAY, " / ").add(CCGLang.number(total).style(ChatFormatting.DARK_GRAY));
    }

    @NotNull
    public static LangBuilder enabled(boolean enabled) {
        return enabled ? CCGLang.translate(ChatFormatting.GREEN, "message.enabled", new Object[0]) : CCGLang.translate(ChatFormatting.RED, "message.disabled", new Object[0]);
    }

    @NotNull
    public static LangBuilder seconds() {
        return CreateLang.translate((String)"generic.unit.seconds", (Object[])new Object[0]);
    }

    @NotNull
    public static LangBuilder item(@NotNull ItemStack stack) {
        return CCGLang.builder().add(stack.getHoverName().copy().setStyle(stack.getDisplayName().getStyle())).text(ChatFormatting.GRAY, " x%d".formatted(stack.getCount()));
    }
}

