/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipFlagType;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipTheme;
import java.util.List;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector2ic;

public class Overlay {
    public static int hoverTicks;

    public static void register(@NotNull RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "item_tooltip_overlay", Overlay::renderOverlay);
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        if (!CCG.CONFIG.overlay.renderExtraItems || !CCG.CONFIG.gameMode.enableGoggles) {
            return;
        }
        if (CCGUtil.mc.m_91104_() || CCGUtil.isInGUI() || CCGUtil.mc.f_91066_.f_92062_) {
            hoverTicks = 0;
            return;
        }
        if (!CCG.CONFIG.goggles.canRenderOnValueBox && CCGUtil.hasActivedValueBox()) {
            return;
        }
        ItemStack itemStack = Overlay.toRenderItemStack();
        if (itemStack.m_41619_()) {
            hoverTicks = 0;
        } else {
            Overlay.renderItemStack(graphics, itemStack);
        }
    }

    @NotNull
    public static ItemStack toRenderItemStack() {
        try {
            BlockEntity blockEntity = CCGUtil.getBlockEntity();
            if (blockEntity instanceof IItemRenderable) {
                IItemRenderable renderable = (IItemRenderable)blockEntity;
                return CCGUtil.orEmpty(renderable.ccg$getItemStack());
            }
            blockEntity = CCGUtil.getEntity();
            if (blockEntity instanceof IItemRenderable) {
                IItemRenderable renderable = (IItemRenderable)blockEntity;
                return CCGUtil.orEmpty(renderable.ccg$getItemStack());
            }
        }
        catch (Throwable e) {
            CCG.LOGGER.error("Failed to get item stack from IItemRenderable", e);
        }
        return ItemStack.f_41583_;
    }

    public static void renderItemStack(@NotNull GuiGraphics graphics, @NotNull ItemStack itemStack) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        CCGConfig.Overlay overlay = CCG.CONFIG.overlay;
        CClient cfg = AllConfigs.client();
        TooltipTheme.Theme theme = Overlay.getTheme();
        Color back = theme.backColor();
        Color top = theme.topColor();
        Color bot = theme.botColor();
        float fade = Mth.m_14036_((float)((CCGUtil.getRealtimeDeltaTicks() + (float)hoverTicks++) / 24.0f), (float)0.0f, (float)1.0f);
        if (fade < 1.0f) {
            pose.m_85837_(Math.pow(1.0f - fade, 3.0) * Math.signum((double)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5) * 8.0, 0.0, 0.0);
            back.scaleAlpha(fade);
            top.scaleAlpha(fade);
            bot.scaleAlpha(fade);
        }
        int width = graphics.m_280182_();
        int height = graphics.m_280206_();
        int x = width / 2 + (Integer)cfg.overlayOffsetX.get() + overlay.overlayOffsetX;
        int y = height / 2 + (Integer)cfg.overlayOffsetY.get() + overlay.overlayOffsetY;
        List<FormattedCharSequence> tooltips = Overlay.getFormattedTooltips(itemStack, width - x - 16);
        int tooltipWidth = tooltips.stream().mapToInt(arg_0 -> ((Font)CCGUtil.mc.f_91062_).m_92724_(arg_0)).max().orElse(0);
        int tooltipHeight = tooltips.size() * 10;
        if (GoggleOverlayRenderer.hoverTicks != 0) {
            y -= tooltipHeight + 10;
        }
        x = Mth.m_14045_((int)x, (int)0, (int)(width - tooltipWidth));
        y = Mth.m_14045_((int)y, (int)16, (int)(height - tooltipHeight - 100));
        Overlay.renderTooltip(graphics, itemStack, tooltips, x, y, tooltipWidth, tooltipHeight, back.getRGB(), top.getRGB(), bot.getRGB());
        pose.m_252880_((float)x + 14.0f, (float)y - 14.0f, 450.0f);
        pose.m_85841_(0.75f, 0.75f, 1.0f);
        graphics.m_280480_(itemStack, 0, 0);
        graphics.m_280370_(CCGUtil.mc.f_91062_, itemStack, 0, 0);
        pose.m_85849_();
    }

    @NotNull
    public static TooltipTheme.Theme getTheme() {
        CCGConfig.Overlay overlay = CCG.CONFIG.overlay;
        boolean useCCGCustom = overlay.useCustomColor;
        TooltipTheme tooltipTheme = CCG.CONFIG.overlay.tooltipTheme;
        if (!useCCGCustom && tooltipTheme != null) {
            TooltipTheme.Theme theme = tooltipTheme.theme;
            if (theme != null) {
                return theme;
            }
            CClient cfg = AllConfigs.client();
            Boolean useCreateCustom = (Boolean)cfg.overlayCustomColor.get();
            Color back = useCreateCustom != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
            Color top = useCreateCustom != false ? new Color(((Integer)cfg.overlayBorderColorTop.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy();
            Color bot = useCreateCustom != false ? new Color(((Integer)cfg.overlayBorderColorBot.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy();
            return new TooltipTheme.Theme(back, top, bot);
        }
        return new TooltipTheme.Theme(overlay.backgroundColor, overlay.borderTopColor, overlay.borderBottomColor);
    }

    @NotNull
    public static @Unmodifiable List<FormattedCharSequence> getFormattedTooltips(@NotNull ItemStack itemStack, int maxWidth) {
        TooltipFlagType type = CCG.CONFIG.overlay.tooltipFlagType;
        if (type == null) {
            type = TooltipFlagType.Default;
        }
        List tooltipLines = itemStack.m_41651_((Player)CCGUtil.mc.f_91074_, (TooltipFlag)type.getFlag());
        tooltipLines.set(0, Component.m_237113_((String)" ".repeat(Mth.m_14167_((float)(16.0f / (float)CCGUtil.mc.f_91062_.m_92895_(" "))))).m_7220_((Component)tooltipLines.get(0)));
        return tooltipLines.stream().flatMap(line -> CCGUtil.mc.f_91062_.m_92923_((FormattedText)line, maxWidth).stream()).toList();
    }

    public static void renderTooltip(GuiGraphics graphics, ItemStack itemStack, @NotNull List<FormattedCharSequence> tooltips, int x, int y, int tooltipWidth, int tooltipHeight, int back, int top, int bot) {
        ClientTooltipPositioner positioner;
        int height;
        List<ClientTooltipComponent> components = tooltips.stream().map(ClientTooltipComponent::m_169948_).toList();
        if (components.isEmpty()) {
            return;
        }
        int width = graphics.m_280182_();
        if (ForgeHooksClient.onRenderTooltipPre((ItemStack)itemStack, (GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)(height = graphics.m_280206_()), components, (Font)CCGUtil.mc.f_91062_, (ClientTooltipPositioner)(positioner = DefaultTooltipPositioner.f_262752_)).isCanceled()) {
            return;
        }
        Vector2ic tooltipPos = positioner.m_262814_(width, height, x, y, tooltipWidth, tooltipHeight);
        int tooltipX = tooltipPos.x();
        int tooltipY = tooltipPos.y();
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)tooltipX, (int)tooltipY, (int)tooltipWidth, (int)tooltipHeight, (int)400, (int)back, (int)back, (int)top, (int)bot);
        pose.m_252880_(0.0f, 0.0f, 400.0f);
        int i = 0;
        int textY = tooltipY;
        for (ClientTooltipComponent component : components) {
            component.m_142440_(CCGUtil.mc.f_91062_, tooltipX, textY, pose.m_85850_().m_252922_(), graphics.m_280091_());
            component.m_183452_(CCGUtil.mc.f_91062_, tooltipX, textY, graphics);
            textY += component.m_142103_() + (i == 0 ? 2 : 0);
            ++i;
        }
        pose.m_85849_();
    }
}

