/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.armor.CardboardArmorItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCGUtil {
    public static final Minecraft mc = Minecraft.m_91087_();
    public static final Outliner outliner = Outliner.getInstance();
    private static HitResult cachedHitResult;
    private static float lastTick;

    @Contract(pure=true)
    public static boolean isInGUI() {
        return CCGUtil.mc.f_91080_ != null;
    }

    @Contract(pure=true)
    public static boolean isInGame() {
        return !CCGUtil.isInGUI();
    }

    public static boolean isClient() {
        return EffectiveSide.get().isClient();
    }

    public static boolean isServer() {
        return !CCGUtil.isClient();
    }

    public static float getRealtimeDeltaTicks() {
        return mc.m_91296_();
    }

    @Nullable
    public static <T extends U, U> T getAs(@NotNull Class<T> clazz, U object) {
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    private static HitResult getCurrentHitResult() {
        float currentTick;
        float f = currentTick = CCGUtil.mc.f_91073_ != null ? CCGUtil.getRealtimeDeltaTicks() : 0.0f;
        if (lastTick == currentTick && cachedHitResult != null) {
            return cachedHitResult;
        }
        cachedHitResult = CCGUtil.mc.f_91077_;
        lastTick = currentTick;
        return cachedHitResult;
    }

    @Contract(pure=true)
    @Nullable
    public static BlockHitResult getBlockHitResult() {
        BlockHitResult result;
        HitResult hitResult = CCGUtil.getCurrentHitResult();
        return hitResult instanceof BlockHitResult && (result = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.MISS ? result : null;
    }

    @Contract(pure=true)
    @Nullable
    public static EntityHitResult getEntityHitResult() {
        EntityHitResult result;
        HitResult hitResult = CCGUtil.getCurrentHitResult();
        return hitResult instanceof EntityHitResult ? (result = (EntityHitResult)hitResult) : null;
    }

    @Nullable
    public static BlockEntity getBlockEntity() {
        if (CCGUtil.mc.f_91073_ == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.f_91073_.m_7702_(result.m_82425_());
    }

    @Nullable
    public static <T extends BlockEntity> T getBlockEntity(Class<T> clazz) {
        return (T)((BlockEntity)CCGUtil.getAs(clazz, CCGUtil.getBlockEntity()));
    }

    @Nullable
    public static Block getBlock() {
        if (CCGUtil.mc.f_91073_ == null) {
            return null;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return CCGUtil.mc.f_91073_.m_8055_(result.m_82425_()).m_60734_();
    }

    @Nullable
    public static <T extends Block> T getBlock(Class<T> clazz) {
        return (T)((Block)CCGUtil.getAs(clazz, CCGUtil.getBlock()));
    }

    @Nullable
    public static Entity getEntity() {
        EntityHitResult result = CCGUtil.getEntityHitResult();
        return result != null ? result.m_82443_() : null;
    }

    @Contract(value="!null -> param1", pure=true)
    @NotNull
    public static ItemStack orEmpty(@Nullable ItemStack itemStack) {
        return Objects.requireNonNullElse(itemStack, ItemStack.f_41583_);
    }

    @Nullable
    public static ItemStack getSelectedFilter() {
        if (CCGUtil.isInGUI()) {
            Screen screen = CCGUtil.mc.f_91080_;
            if (!(screen instanceof AbstractContainerScreen)) {
                return null;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            return slot == null ? null : slot.m_7993_();
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        SmartBlockEntity sbe = CCGUtil.getBlockEntity(SmartBlockEntity.class);
        if (sbe == null || result == null) {
            return null;
        }
        FilteringBehaviour behaviour = (FilteringBehaviour)sbe.getBehaviour(FilteringBehaviour.TYPE);
        return behaviour == null ? null : behaviour.getFilter(result.m_82434_());
    }

    @NotNull
    public static AABB getBounds(BlockPos blockPos) {
        if (CCGUtil.mc.f_91073_ == null) {
            return Shapes.m_83144_().m_83215_();
        }
        VoxelShape shape = CCGUtil.mc.f_91073_.m_8055_(blockPos).m_60808_((BlockGetter)CCGUtil.mc.f_91073_, blockPos);
        return (shape.m_83281_() ? Shapes.m_83144_() : shape).m_83215_().m_82338_(blockPos);
    }

    public static boolean hasActivedValueBox() {
        for (Outliner.OutlineEntry entry : outliner.getOutlines().values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox)) continue;
            ValueBox valueBox = (ValueBox)outline;
            if (valueBox.isPassive) continue;
            return true;
        }
        return false;
    }

    public static boolean testForStealth() {
        if (CCGUtil.mc.f_91074_ == null) {
            return false;
        }
        boolean allMatch = Stream.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET).allMatch(slot -> CCGUtil.mc.f_91074_.m_6844_(slot).m_41720_() instanceof CardboardArmorItem);
        return CCG.CONFIG.chainConveyor.cardBoardedYourself && !CCGUtil.mc.f_91074_.m_150110_().f_35935_ && allMatch;
    }

    public static boolean hasItemInHand() {
        return CCGUtil.mc.f_91074_ != null && !Stream.of(CCGUtil.mc.f_91074_.m_21205_(), CCGUtil.mc.f_91074_.m_21206_()).allMatch(ItemStack::m_41619_);
    }

    public static void playSound(SoundEvent sound, float pitch, float volume) {
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void toggleConfig(boolean keyDown, boolean enabled, Consumer<Boolean> setter, String messageKey) {
        if (!keyDown) {
            return;
        }
        if (CCGUtil.isInGUI()) {
            return;
        }
        boolean newEnabled = !enabled;
        setter.accept(newEnabled);
        if (CCGUtil.mc.f_91074_ == null) {
            return;
        }
        CCGLang.translate(messageKey, new Object[0]).space().add(CCGLang.enabled(newEnabled)).sendStatus((Player)CCGUtil.mc.f_91074_);
    }

    public static void sendAction(ServerboundPlayerCommandPacket.Action action) {
        if (CCGUtil.mc.f_91074_ == null) {
            return;
        }
        CCGUtil.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerCommandPacket((Entity)CCGUtil.mc.f_91074_, action));
    }

    public static void sendToServer(SimplePacketBase packet) {
        AllPackets.getChannel().sendToServer((Object)packet);
    }
}

