/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import net.createmod.catnip.theme.Color;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TooltipTheme {
    Default,
    Vanilla(-267386864, 0x505000FF, 1344798847),
    Dark(Integer.MIN_VALUE, 0, 0),
    Create(-1072689136, 0x50505050, 0x30303030),
    Cyber(-2147483616, -16711808, -2147418240),
    Neon(-2147483393, -65281, -2147418113);

    @Nullable
    public final Theme theme;

    private TooltipTheme(int back, int top, int bot) {
        this.theme = new Theme(back, top, bot);
    }

    @Contract(pure=true)
    private TooltipTheme() {
        this.theme = null;
    }

    @NotNull
    public String toString() {
        return CCGLang.translate("tooltipTheme." + this.name(), new Object[0]).string();
    }

    public record Theme(int back, int top, int bot) {
        public Theme(@NotNull Color back, @NotNull Color top, @NotNull Color bot) {
            this(back.getRGB(), top.getRGB(), bot.getRGB());
        }

        @Contract(value=" -> new", pure=true)
        @NotNull
        public Color backColor() {
            return new Color(this.back);
        }

        @Contract(value=" -> new", pure=true)
        @NotNull
        public Color topColor() {
            return new Color(this.top);
        }

        @Contract(value=" -> new", pure=true)
        @NotNull
        public Color botColor() {
            return new Color(this.bot);
        }
    }
}

