/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BeltBlockEntity.class}, remap=false)
public abstract class BeltBlockEntityMixin
extends KineticBlockEntity
implements IHaveGoggleInformation,
IItemRenderable {
    @Unique
    public final Deque<Integer> ccg$itemHistory = new ArrayDeque<Integer>();
    @Shadow
    public int index;
    @Unique
    public double ccg$rate;
    @Unique
    public int ccg$lastTotalItems;

    public BeltBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        if (this.index != 0) {
            return;
        }
        int currentTotalItems = 0;
        for (TransportedItemStack ts : this.getInventory().getTransportedItems()) {
            if (ts == null || ts.stack == null) continue;
            currentTotalItems += ts.stack.m_41613_();
        }
        int itemsPassed = Math.max(0, this.ccg$lastTotalItems - currentTotalItems);
        this.ccg$lastTotalItems = currentTotalItems;
        this.ccg$itemHistory.addLast(itemsPassed);
        if (this.ccg$itemHistory.size() > 60) {
            this.ccg$itemHistory.pollFirst();
        }
        this.ccg$rate = (this.ccg$rate + this.ccg$itemHistory.stream().mapToInt(Integer::intValue).average().orElse(0.0) * 20.0) / 2.0;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean add = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!CCG.CONFIG.goggles.enhancedInfo || this.getSpeed() == 0.0f) {
            return add;
        }
        BeltBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE != null) {
            TooltipUtil.beltThroughput(tooltip, ((BeltBlockEntityMixin)controllerBE).ccg$rate);
        }
        return add;
    }

    @Shadow
    public abstract BeltBlockEntity getControllerBE();

    @Shadow
    public abstract BeltInventory getInventory();

    @Override
    public ItemStack ccg$getItemStack() {
        BeltInventory inventory = this.getInventory();
        if (inventory == null) {
            return null;
        }
        TransportedItemStack stackAtOffset = inventory.getStackAtOffset(this.index);
        return stackAtOffset == null ? null : stackAtOffset.stack;
    }
}

