/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.create_cyber_goggles.content.event;

import com.forgestove.create_cyber_goggles.Config;
import com.forgestove.create_cyber_goggles.content.event.KeyBind;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreen;
import com.simibubi.create.content.logistics.filter.PackageFilterMenu;
import com.simibubi.create.content.logistics.filter.PackageFilterScreen;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import org.jetbrains.annotations.NotNull;

public class KeyInput {
    public static void openConfigScreen(InputEvent.Key event) {
        if (!KeyBind.isAction(event, KeyBind.OPEN_CONFIG, 1)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        Optional modContainerById = ModList.get().getModContainerById("create_cyber_goggles");
        if (modContainerById.isEmpty()) {
            return;
        }
        ModContainer modContainer = (ModContainer)modContainerById.get();
        mc.pushGuiLayer((Screen)new ConfigurationScreen(modContainer, mc.screen));
    }

    public static void openFilterScreen(InputEvent.Key event) {
        if (!((Boolean)Config.enableOpenFilterScreen.get()).booleanValue()) {
            return;
        }
        if (!KeyBind.isAction(event, KeyBind.PREVIEW_FILTER, 1)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            Screen screen = mc.screen;
            if (!(screen instanceof AbstractContainerScreen)) {
                return;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            KeyInput.setFilterScreen(slot.getItem());
        } else {
            HitResult slot;
            if (mc.level == null || !((slot = mc.hitResult) instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)slot;
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            BlockEntity blockEntity = mc.level.getBlockEntity(blockHitResult.getBlockPos());
            if (!(blockEntity instanceof SmartBlockEntity)) {
                return;
            }
            SmartBlockEntity smartBlockEntity = (SmartBlockEntity)blockEntity;
            Set<FilteringBehaviour> behavior = Collections.singleton((FilteringBehaviour)smartBlockEntity.getBehaviour(FilteringBehaviour.TYPE));
            FilteringBehaviour first = behavior.iterator().next();
            if (!(first instanceof FilteringBehaviour)) {
                return;
            }
            KeyInput.setFilterScreen(first.getFilter(blockHitResult.getDirection()));
        }
    }

    public static void setFilterScreen(@NotNull ItemStack filter) {
        if (filter.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Inventory inventory = player.getInventory();
        Component hoverName = filter.getHoverName();
        switch (filter.getDescriptionId()) {
            case "item.create.filter": {
                FilterMenu menu = FilterMenu.create((int)0, (Inventory)inventory, (ItemStack)filter);
                mc.setScreen((Screen)new FilterScreen(menu, inventory, hoverName));
                break;
            }
            case "item.create.attribute_filter": {
                AttributeFilterMenu menu = AttributeFilterMenu.create((int)0, (Inventory)inventory, (ItemStack)filter);
                mc.setScreen((Screen)new AttributeFilterScreen(menu, inventory, hoverName));
                break;
            }
            case "item.create.package_filter": {
                PackageFilterMenu menu = PackageFilterMenu.create((int)0, (Inventory)inventory, (ItemStack)filter);
                mc.setScreen((Screen)new PackageFilterScreen(menu, inventory, hoverName));
            }
        }
    }
}

