/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.create_cyber_goggles.mixin.goggles;

import com.forgestove.create_cyber_goggles.Config;
import com.forgestove.create_cyber_goggles.content.event.MoseScroll;
import com.forgestove.create_cyber_goggles.content.render.OverlayRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.logistics.tableCloth.BlueprintOverlayShopContext;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlueprintOverlayRenderer.class})
public abstract class BlueprintOverlayRendererMixin {
    @Shadow
    static boolean active;
    @Shadow
    static boolean empty;
    @Shadow
    static List<Pair<ItemStack, Boolean>> ingredients;
    @Shadow
    static List<ItemStack> results;
    @Shadow
    static boolean noOutput;
    @Shadow
    static boolean resultCraftable;
    @Shadow
    static BlueprintOverlayShopContext shopContext;

    @Inject(method={"renderOverlay"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo callbackInfo) {
        if (!((Boolean)Config.enhancedStoreRender.get()).booleanValue()) {
            return;
        }
        callbackInfo.cancel();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.screen != null) {
            return;
        }
        if (!active || empty) {
            return;
        }
        boolean invalidShop = shopContext != null && (ingredients.isEmpty() || ((ItemStack)ingredients.getFirst().getFirst()).isEmpty() || shopContext.stockLevel() == 0);
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 21 * results.size();
            w += 30;
        }
        int x = (guiGraphics.guiWidth() - w) / 2;
        int y = guiGraphics.guiHeight() - 100;
        if (shopContext != null) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(x - 2), (int)(y + 1), (int)(w + 4), (int)19, (int)0, (int)0x55000000, (int)0x55000000, (int)0, (int)0);
            AllGuiTextures.TRADE_OVERLAY.render(guiGraphics, guiGraphics.guiWidth() / 2 - 48, y - 19);
            if (shopContext.purchases() > 0) {
                guiGraphics.renderItem(AllItems.SHOPPING_LIST.asStack(), guiGraphics.guiWidth() / 2 + 20, y - 20);
                guiGraphics.drawString(mc.font, (Component)Component.literal((String)("x" + shopContext.purchases())), guiGraphics.guiWidth() / 2 + 20 + 16, y - 20 + 4, -1118482, true);
            }
        }
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            ((Boolean)pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(guiGraphics, x, y);
            ItemStack itemStack = (ItemStack)pair.getFirst();
            String count = shopContext != null && !shopContext.checkout() || (Boolean)pair.getSecond() != false ? null : ChatFormatting.GOLD.toString() + itemStack.getCount();
            BlueprintOverlayRenderer.drawItemStack((GuiGraphics)guiGraphics, (Minecraft)mc, (int)x, (int)y, (ItemStack)itemStack, (String)count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        x += 5;
        RenderSystem.enableBlend();
        if (invalidShop) {
            AllGuiTextures.HOTSLOT_ARROW_BAD.render(guiGraphics, x, y + 4);
        } else {
            AllGuiTextures.HOTSLOT_ARROW.render(guiGraphics, x, y + 4);
        }
        x += 25;
        if (results.isEmpty()) {
            AllGuiTextures.HOTSLOT.render(guiGraphics, x, y);
            GuiGameElement.of((ItemLike)Items.BARRIER).at((float)(x + 3), (float)(y + 3)).render(guiGraphics);
        } else {
            MoseScroll.index += MoseScroll.scrollDeltaY;
            MoseScroll.scrollDeltaY = 0;
            if (MoseScroll.index < 1) {
                MoseScroll.index = results.size();
            } else if (MoseScroll.index > results.size()) {
                MoseScroll.index = 1;
            }
            int selectedX = 0;
            int resultsSize = results.size();
            for (int i = 0; i < resultsSize; ++i) {
                AllGuiTextures slot;
                ItemStack result = results.get(i);
                AllGuiTextures allGuiTextures = slot = resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT;
                if (!invalidShop && shopContext != null && shopContext.stockLevel() > shopContext.purchases()) {
                    slot = AllGuiTextures.HOTSLOT_ACTIVE;
                }
                slot.render(guiGraphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
                BlueprintOverlayRenderer.drawItemStack((GuiGraphics)guiGraphics, (Minecraft)mc, (int)x, (int)y, (ItemStack)result, null);
                if (i == MoseScroll.index - 1) {
                    selectedX = x;
                }
                x += 21;
            }
            if (selectedX != 0) {
                guiGraphics.blitSprite(ResourceLocation.withDefaultNamespace((String)"hud/hotbar_selection"), selectedX - 1, y - 1, 24, 23);
            }
            OverlayRenderer.renderItemStack(guiGraphics, results.get(MoseScroll.index - 1));
        }
        if (shopContext != null) {
            shopContext.checkout();
        }
        RenderSystem.disableBlend();
    }
}

