/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.Common;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.ArmBlockEntityAccessor;
import io.github.forgestove.create_cyber_goggles.mixin.accessor.NozzleBlockEntityAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.NotNull;

public class DelayRender {
    public static final Object2IntOpenHashMap<BlockEntity> cachedBE = new Object2IntOpenHashMap();

    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (!CCG.CONFIG.delayRender.renderAnalogBox) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            cachedBE.clear();
            return;
        }
        if (mc.isPaused() || mc.screen != null) {
            return;
        }
        BlockEntity be = Common.getBE();
        if (be instanceof EncasedFanBlockEntity || be instanceof NozzleBlockEntity || be instanceof ArmBlockEntity || be instanceof EjectorBlockEntity || be instanceof PackagePortBlockEntity) {
            cachedBE.put((Object)be, CCG.CONFIG.delayRender.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.object2IntEntrySet().removeIf(entry -> {
            BlockEntity blockEntity = (BlockEntity)entry.getKey();
            int newValue = entry.getIntValue() - 1;
            entry.setValue(newValue);
            if (!blockEntity.isRemoved()) {
                BlockEntity blockEntity2 = blockEntity;
                Objects.requireNonNull(blockEntity2);
                BlockEntity selector0$temp = blockEntity2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EncasedFanBlockEntity.class, NozzleBlockEntity.class, ArmBlockEntity.class, EjectorBlockEntity.class, PackagePortBlockEntity.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        EncasedFanBlockEntity efbe = (EncasedFanBlockEntity)selector0$temp;
                        DelayRender.render(efbe);
                        break;
                    }
                    case 1: {
                        NozzleBlockEntity nbe = (NozzleBlockEntity)selector0$temp;
                        DelayRender.render(nbe);
                        break;
                    }
                    case 2: {
                        ArmBlockEntity abe = (ArmBlockEntity)selector0$temp;
                        DelayRender.render(abe);
                        break;
                    }
                    case 3: {
                        EjectorBlockEntity ebe = (EjectorBlockEntity)selector0$temp;
                        DelayRender.render(ebe);
                        break;
                    }
                    case 4: {
                        PackagePortBlockEntity ppbe = (PackagePortBlockEntity)selector0$temp;
                        DelayRender.render(ppbe);
                        break;
                    }
                }
            }
            return newValue <= 0;
        });
    }

    public static void render(@NotNull EncasedFanBlockEntity efbe) {
        AirCurrent airCurrent = efbe.airCurrent;
        int color = DelayRender.getColor(airCurrent.pushing);
        AABB bounds = airCurrent.bounds;
        Outliner.getInstance().chaseAABB((Object)("FanAirBox" + String.valueOf(efbe)), bounds).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(airCurrent.maxDistance);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)airCurrent.maxDistance * offset;
            Direction.Axis axis = airCurrent.direction.getAxis();
            double min = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.minX;
                case Direction.Axis.Y -> bounds.minY;
                case Direction.Axis.Z -> bounds.minZ;
            };
            double max = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> bounds.maxX;
                case Direction.Axis.Y -> bounds.maxY;
                case Direction.Axis.Z -> bounds.maxZ;
            };
            double pos = airCurrent.pushing == airCurrent.direction.getAxisDirection().getStep() > 0 ? min + offsetDistance : max - offsetDistance;
            AABB flowBound = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new AABB(pos, bounds.minY, bounds.minZ, pos, bounds.maxY, bounds.maxZ);
                case Direction.Axis.Y -> new AABB(bounds.minX, pos, bounds.minZ, bounds.maxX, pos, bounds.maxZ);
                case Direction.Axis.Z -> new AABB(bounds.minX, bounds.minY, pos, bounds.maxX, bounds.maxY, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(efbe) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static void render(@NotNull NozzleBlockEntity nbe) {
        NozzleBlockEntityAccessor accessor = (NozzleBlockEntityAccessor)nbe;
        boolean pushing = accessor.getPushing();
        float range = accessor.getRange();
        Vec3 center = nbe.getBlockPos().getCenter();
        int color = DelayRender.getColor(pushing);
        Outliner.getInstance().chaseAABB((Object)("NozzleAirBox" + String.valueOf(nbe)), new AABB(center, center).inflate((double)(range / 2.0f))).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(range);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(nbe) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            double radius = pushing ? offset * (double)range / 2.0 : (1.0 - offset) * (double)range / 2.0;
            AABB flowBound = new AABB(center, center).inflate(radius);
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.delayRender.windPushColor : CCG.CONFIG.delayRender.windPullColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }

    public static void render(@NotNull ArmBlockEntity abe) {
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)abe;
        ArrayList<ArmInteractionPoint> allPoints = new ArrayList<ArmInteractionPoint>();
        allPoints.addAll(accessor.getInputs());
        allPoints.addAll(accessor.getOutputs());
        allPoints.forEach(point -> {
            if (!point.isValid()) {
                return;
            }
            Level level = point.getLevel();
            BlockPos pos = point.getPos();
            Outliner.getInstance().chaseAABB((Object)("ArmIOBox" + String.valueOf(point)), level.getBlockState(pos).getShape((BlockGetter)level, pos).bounds().move(pos)).withFaceTextures((BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(point.getMode().getColor());
            Outliner.getInstance().showLine((Object)("ArmIOLine" + String.valueOf(point)), abe.getBlockPos().getCenter(), point.getPos().getCenter()).lineWidth(0.125f).colored(point.getMode().getColor());
        });
    }

    public static void render(@NotNull EjectorBlockEntity ebe) {
        AABB bounds = Common.getBounds(ebe.getTargetPosition());
        if (bounds == null) {
            return;
        }
        Outliner.getInstance().chaseAABB((Object)("EjectorTargetBox" + String.valueOf(ebe)), bounds).lineWidth(0.0625f).colored(CCG.CONFIG.delayRender.windPushColor);
    }

    public static void render(@NotNull PackagePortBlockEntity ppbe) {
        Minecraft mc = Minecraft.getInstance();
        BlockPos pos = ppbe.getBlockPos();
        if (ppbe.target == null) {
            return;
        }
        Vec3 source = Vec3.atBottomCenterOf((Vec3i)pos);
        Vec3 target = ppbe.target.getExactTargetLocation(ppbe, (LevelAccessor)mc.level, pos);
        if (target == Vec3.ZERO) {
            return;
        }
        int color = 10411635;
        Outliner.getInstance().showLine((Object)("PackagePortConnection" + String.valueOf(ppbe)), source, target).lineWidth(0.125f).colored(color);
        Outliner.getInstance().chaseAABB((Object)("ChainPointSelected" + String.valueOf(ppbe)), new AABB(target, target)).colored(color).lineWidth(0.2f).disableLineNormals();
    }
}

