/*
 * Decompiled with CFR 0.152.
 */
package com.forgestove.create_cyber_goggles.content.event;

import com.forgestove.create_cyber_goggles.Config;
import com.forgestove.create_cyber_goggles.content.event.KeyBind;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreen;
import com.simibubi.create.content.logistics.filter.PackageFilterMenu;
import com.simibubi.create.content.logistics.filter.PackageFilterScreen;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import org.jetbrains.annotations.NotNull;

public class KeyInput {
    public static void openConfigScreen(InputEvent.Key event) {
        if (!KeyBind.isAction(event, KeyBind.OPEN_CONFIG, 1)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        Optional modContainerById = ModList.get().getModContainerById("create_cyber_goggles");
        if (modContainerById.isEmpty()) {
            return;
        }
        ModContainer modContainer = (ModContainer)modContainerById.get();
        mc.setScreen((Screen)new ConfigurationScreen(modContainer, mc.screen));
    }

    public static void openFilterScreen(InputEvent.Key event) {
        if (!((Boolean)Config.enableOpenFilterScreen.get()).booleanValue()) {
            return;
        }
        if (!KeyBind.isAction(event, KeyBind.PREVIEW_FILTER, 1)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            Screen screen = mc.screen;
            if (!(screen instanceof AbstractContainerScreen)) {
                return;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            ItemStack item = slot.getItem();
            if (!(item.getItem() instanceof FilterItem)) {
                return;
            }
            KeyInput.setFilterScreen(item);
        } else {
            HitResult slot;
            if (mc.level == null || !((slot = mc.hitResult) instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)slot;
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            BlockEntity blockEntity = mc.level.getBlockEntity(blockHitResult.getBlockPos());
            if (!(blockEntity instanceof SmartBlockEntity)) {
                return;
            }
            SmartBlockEntity smartBlockEntity = (SmartBlockEntity)blockEntity;
            Set<FilteringBehaviour> behavior = Collections.singleton((FilteringBehaviour)smartBlockEntity.getBehaviour(FilteringBehaviour.TYPE));
            FilteringBehaviour first = behavior.iterator().next();
            if (!(first instanceof FilteringBehaviour)) {
                return;
            }
            ItemStack item = first.getFilter(blockHitResult.getDirection());
            if (!(item.getItem() instanceof FilterItem)) {
                return;
            }
            KeyInput.setFilterScreen(item);
        }
    }

    public static void setFilterScreen(@NotNull ItemStack filter) {
        try {
            FilterScreen screen;
            Field field = FilterItem.class.getDeclaredField("type");
            field.setAccessible(true);
            Item item = filter.getItem();
            if (!(item instanceof FilterItem)) {
                return;
            }
            FilterItem filterItem = (FilterItem)item;
            if (!field.getType().isEnum()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            Inventory inv = player.getInventory();
            Component name = filter.getHoverName();
            switch (((Enum)field.get(filterItem)).ordinal()) {
                case 0: {
                    screen = new FilterScreen(FilterMenu.create((int)-1, (Inventory)inv, (ItemStack)filter), inv, name);
                    break;
                }
                case 1: {
                    screen = new AttributeFilterScreen(AttributeFilterMenu.create((int)-1, (Inventory)inv, (ItemStack)filter), inv, name);
                    break;
                }
                case 2: {
                    screen = new PackageFilterScreen(PackageFilterMenu.create((int)-1, (Inventory)inv, (ItemStack)filter), inv, name);
                    break;
                }
                default: {
                    return;
                }
            }
            mc.setScreen((Screen)screen);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

