/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.content.chemical;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerBlockItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.chemical.ExtraChemicalStorageVariant;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ExtraChemicalStorageBlockItem
extends AbstractStorageContainerBlockItem
implements UpgradeableStorageContainer {
    private final ExtraChemicalStorageVariant variant;
    private final Component helpText;

    public ExtraChemicalStorageBlockItem(Block block, ExtraChemicalStorageVariant variant) {
        super(block, new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = variant.hasCapacity() ? MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation((String)"item", (String)"chemical_storage_block.help", (Object[])new Object[]{IdentifierUtil.format((long)variant.getCapacity())}) : MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation((String)"item", (String)"creative_chemical_storage_block.help");
    }

    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    @Nonnull
    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(ChemicalResource.class).formatAmount(amount);
    }

    @Nonnull
    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return ChemicalResourceType.STORAGE_TYPE.create(this.variant.getCapacity(), () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    @Nonnull
    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Registration.ADVANCED_MACHINE_CASING.asItem(), count);
    }

    @Nullable
    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Registration.CHEMICAL_STORAGE_PART.get((Object)this.variant).asItem(), count);
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    @Nonnull
    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

