/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.content.item;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import de.melanx.extradisks.ModConfig;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.item.ExtraItemStorageVariant;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ExtraItemStorageBlockProvider
implements StorageBlockProvider {
    private final ExtraItemStorageVariant variant;
    private final Component displayName;

    public ExtraItemStorageBlockProvider(ExtraItemStorageVariant variant) {
        this.variant = variant;
        this.displayName = Component.translatable((String)("block.extradisks." + variant.getName() + "_storage_block"));
    }

    @Nonnull
    public SerializableStorage createStorage(@Nonnull Runnable runnable) {
        return StorageTypes.ITEM.create(this.variant.getCapacity(), runnable);
    }

    @Nonnull
    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case ExtraItemStorageVariant.TIER_5 -> ((Integer)ModConfig.tier5usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_6 -> ((Integer)ModConfig.tier6usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_7 -> ((Integer)ModConfig.tier7usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_8 -> ((Integer)ModConfig.tier8usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_9 -> ((Integer)ModConfig.tier9usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_10 -> ((Integer)ModConfig.tier10usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_11 -> ((Integer)ModConfig.tier11usage.get()).intValue();
            case ExtraItemStorageVariant.TIER_12 -> ((Integer)ModConfig.tier12usage.get()).intValue();
        };
    }

    @Nonnull
    public ResourceFactory getResourceFactory() {
        return RefinedStorageApi.INSTANCE.getItemResourceFactory();
    }

    @Nonnull
    public BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)Registration.ITEM_STORAGE_TILE.get((Object)this.variant).get();
    }

    @Nonnull
    public MenuType<?> getMenuType() {
        return Menus.INSTANCE.getItemStorage();
    }
}

