/*
 * Decompiled with CFR 0.152.
 */
package com.lu7creative.lu7creative;

import com.lu7creative.lu7creative.lu7creative;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private FileConfiguration config;
    private static final String VERSION_CHECK_URL = "https://plugin.lu7creative.net/version.txt";
    private String currentVersion;
    private JavaPlugin plugin;

    public UpdateChecker(JavaPlugin plugin, String currentVersion) {
        this.plugin = plugin;
        this.currentVersion = currentVersion;
        this.config = plugin.getConfig();
    }

    public boolean checkForUpdates() {
        block3: {
            try {
                URL url = new URL(VERSION_CHECK_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String latestVersion = reader.readLine();
                reader.close();
                if (latestVersion == null || latestVersion.equals(this.currentVersion)) break block3;
                this.plugin.getLogger().info("A new version of the LU7 Creative plugin is available: " + latestVersion);
                this.sendUpdateNotification(latestVersion);
                return true;
            }
            catch (IOException e) {
                String errorMessage = "Error checking for updates! If this issue persists, please create an issue on Github: " + e.getMessage();
                this.plugin.getLogger().warning(errorMessage);
                this.sendErrorNotification(errorMessage);
                return false;
            }
        }
        this.plugin.getLogger().info("You are running the latest version of the LU7 Creative plugin!");
        return false;
    }

    private void sendUpdateNotification(String latestVersion) {
        if (this.config.getBoolean("enableUpdateAvailableNotification", true)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ((lu7creative)this.plugin).sendNotification("Update Available", "A new version of LU7 Creative is available: " + latestVersion, "update,video_game"));
        }
    }

    private void sendErrorNotification(String errorMessage) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ((lu7creative)this.plugin).sendNotification("Update Check Error", errorMessage, "error,video_game"));
    }
}

