/*
 * Decompiled with CFR 0.152.
 */
package com.lu7creative.lu7creative;

import com.lu7creative.lu7creative.UpdateChecker;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class lu7creative
extends JavaPlugin
implements Listener,
CommandExecutor {
    private FileConfiguration config;
    private UpdateChecker updateChecker;
    private String currentVersion = "2.0-SNAPSHOT";

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("lu7creativereload").setExecutor((CommandExecutor)this);
        this.getCommand("lu7creativetest").setExecutor((CommandExecutor)this);
        this.loadConfig();
        this.updateChecker = new UpdateChecker(this, this.currentVersion);
        this.getLogger().log(Level.INFO, "LU7 Creative plugin has been enabled!");
        this.getServer().getScheduler().runTaskLater((Plugin)this, this::checkForUpdates, 20L);
    }

    public void onDisable() {
        this.getLogger().log(Level.INFO, "LU7 Creative plugin has been disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.config.getBoolean("enablePlayerJoinNotification", true) && !event.getPlayer().hasPermission("lu7creative.presencebypass")) {
            this.sendNotification("Player Joined", String.valueOf(event.getPlayer().getName()) + " has just joined the server!", "wave,video_game,player_joined");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.config.getBoolean("enablePlayerQuitNotification", true) && !event.getPlayer().hasPermission("lu7creative.presencebypass")) {
            this.sendNotification("Player Left", String.valueOf(event.getPlayer().getName()) + " left the server!", "wave,video_game,player_left");
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        if (event.getPlugin().equals((Object)this) && this.config.getBoolean("enableServerStartNotification", true)) {
            this.sendNotification("Server Started", "The server has started.", "green_circle,video_game,server_started");
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)this) && this.config.getBoolean("enableServerStopNotification", true)) {
            this.sendNotification("Server Stopped", "The server has stopped.", "red_circle,video_game,server_stopped");
        }
    }

    void sendNotification(String title, String message, String tags) {
        String notificationUrl = this.config.getString("notificationUrl");
        String notificationToken = this.config.getString("notificationToken");
        if (notificationUrl == null || notificationToken == null) {
            this.getLogger().warning("Notification URL or token is not configured. Please set them in config.yml.");
            return;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(notificationUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + notificationToken);
            connection.setRequestProperty("Title", title);
            connection.setRequestProperty("Tags", tags);
            connection.setDoOutput(true);
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = message.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int n = connection.getResponseCode();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to send notification: " + e.getMessage());
        }
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("lu7creativereload") || cmd.getName().equalsIgnoreCase("lu7creativetest")) {
            if (sender.hasPermission("lu7creative.commands")) {
                if (cmd.getName().equalsIgnoreCase("lu7creativereload")) {
                    this.reloadConfig();
                    this.config = this.getConfig();
                    sender.sendMessage("LU7 Creative configuration reloaded.");
                } else if (cmd.getName().equalsIgnoreCase("lu7creativetest")) {
                    if (args.length == 0) {
                        sender.sendMessage("Usage: /lu7creativetest <message>");
                        return true;
                    }
                    StringBuilder message = new StringBuilder();
                    String[] stringArray = args;
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String arg = stringArray[n2];
                        message.append(arg).append(" ");
                        ++n2;
                    }
                    this.sendNotification("Test Notification", message.toString().trim(), "test,video_game");
                    sender.sendMessage("Test notification sent.");
                }
                return true;
            }
            sender.sendMessage("You don't have permission to use this command.");
            return false;
        }
        return false;
    }

    private void checkForUpdates() {
        if (this.updateChecker.checkForUpdates()) {
            this.getLogger().info("An update is available. Please visit Github to download the latest release: https://github.com/LuckVintage/LU7-Creative");
        }
    }
}

