/*
 * Decompiled with CFR 0.152.
 */
package necro.crd.broadcasts.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RequestHandler;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.List;
import java.util.UUID;
import necro.crd.broadcasts.common.CRDBroadcasts;
import necro.crd.broadcasts.common.handler.PlayerHandler;
import necro.crd.broadcasts.common.util.AnnounceMode;
import necro.crd.broadcasts.common.util.ItemValidator;
import necro.crd.broadcasts.common.util.KeyResult;
import necro.crd.broadcasts.common.util.MessageBuilder;
import necro.crd.broadcasts.common.util.RaidBroadcasts;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BroadcastCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"crd").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast").requires(source -> source.method_43737() && CRDBroadcasts.CONFIG.enable_broadcast != AnnounceMode.NONE)).executes(BroadcastCommands::broadcast))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"invite").requires(source -> source.method_43737() && CRDBroadcasts.CONFIG.enable_invite)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(BroadcastCommands::invite)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"request").requires(class_2168::method_43737)).then(class_2170.method_9244((String)"host", (ArgumentType)class_2186.method_9305()).executes(BroadcastCommands::request))));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        BroadcastCommands.register(dispatcher);
    }

    private static int broadcast(CommandContext<class_2168> context) {
        class_3222 host = ((class_2168)context.getSource()).method_44023();
        if (host == null) {
            return 0;
        }
        if (!RaidHelper.isAlreadyHosting((class_1657)host)) {
            return 0;
        }
        RequestHandler handler = RaidHelper.getRequest((class_3222)host);
        if (handler == null) {
            return 0;
        }
        RaidBroadcasts.BROADCASTED.put(host.method_5667(), 0);
        List players = switch (CRDBroadcasts.CONFIG.enable_broadcast) {
            default -> throw new MatchException(null, null);
            case AnnounceMode.NONE -> List.of();
            case AnnounceMode.RANGE -> PlayerHandler.getInRange((class_3218)handler.getBlockEntity().method_10997(), handler.getBlockEntity().method_11016(), CRDBroadcasts.CONFIG.broadcast_range);
            case AnnounceMode.DIMENSION -> PlayerHandler.getInDimension((class_3218)handler.getBlockEntity().method_10997());
            case AnnounceMode.SERVER -> PlayerHandler.getAll((class_3218)handler.getBlockEntity().method_10997());
        };
        players.forEach(p -> p.method_43496(MessageBuilder.broadcast(host, handler.getBlockEntity().getRaidBoss())));
        return 1;
    }

    private static int invite(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 host = ((class_2168)context.getSource()).method_44023();
        class_3222 player = class_2186.method_9315(context, (String)"player");
        if (host == null) {
            return 0;
        }
        if (!RaidHelper.isAlreadyHosting((class_1657)host)) {
            return 0;
        }
        RequestHandler handler = RaidHelper.getRequest((class_3222)host);
        if (handler == null) {
            return 0;
        }
        RaidBroadcasts.INVITED.add(player.method_5667());
        player.method_43496(MessageBuilder.invite(host, handler.getBlockEntity().getRaidBoss()));
        return 1;
    }

    private static int request(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        class_3222 host = class_2186.method_9315(context, (String)"host");
        RequestHandler handler = RaidHelper.getRequest((class_3222)host);
        if (handler == null) {
            return 0;
        }
        RaidCrystalBlockEntity blockEntity = handler.getBlockEntity();
        if (!RaidBroadcasts.BROADCASTED.containsKey(host.method_5667()) && !RaidBroadcasts.INVITED.contains(player.method_5667())) {
            return 0;
        }
        RaidBroadcasts.INVITED.remove(player.method_5667());
        if (!RaidHelper.isAlreadyHosting((class_1657)host)) {
            player.method_43496(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.already_hosting"));
            return 0;
        }
        if (RaidHelper.isAlreadyParticipating((class_1657)player)) {
            player.method_43496(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.already_participating"));
            return 0;
        }
        if (RaidHelper.isInQueue((class_1657)player)) {
            player.method_43496(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.already_in_queue"));
            return 0;
        }
        if (RaidHelper.hasClearedRaid((UUID)blockEntity.getUuid(), (class_1657)player)) {
            player.method_43496(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.player_cleared"));
            return 0;
        }
        if (blockEntity.isFull()) {
            player.method_43496(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.lobby_is_full"));
            return 0;
        }
        class_1799 itemStack = player.method_6047();
        KeyResult result = BroadcastCommands.handleKey(blockEntity, player, itemStack);
        if (result == KeyResult.FAIL) {
            return 0;
        }
        RaidHelper.addToQueue((class_1657)player, (class_1799)(result == KeyResult.CONSUME ? itemStack : null));
        if (result == KeyResult.CONSUME) {
            itemStack.method_57008(1, (class_1309)player);
        }
        RaidHelper.addRequest((class_3222)host, (class_1657)player);
        RaidDenNetworkMessages.REQUEST_PACKET.accept(host, player.method_5477().getString());
        RaidBroadcasts.BROADCASTED.computeIfPresent(host.method_5667(), (uuid, requests) -> {
            requests = requests + 1;
            return requests;
        });
        if (RaidBroadcasts.BROADCASTED.getOrDefault(host.method_5667(), 0) >= CRDBroadcasts.CONFIG.max_requests) {
            RaidBroadcasts.BROADCASTED.remove(host.method_5667());
        }
        RaidBroadcasts.REMOTERS.put(player.method_5667(), player.method_19538());
        return 1;
    }

    private static KeyResult handleKey(RaidCrystalBlockEntity blockEntity, class_3222 player, class_1799 itemStack) {
        RaidBoss boss = blockEntity.getRaidBoss();
        String key = boss.getKey();
        if (((TierConfig)CobblemonRaidDens.TIER_CONFIG.get(boss.getTier())).allRequireUniqueKey() && !key.isEmpty()) {
            if (key.startsWith("#")) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)key.substring(1)));
                if (!itemStack.method_31573(tag)) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.cobblemonraiddens.raid.no_unique_key", (Object[])new Object[]{key.split(":")[1]}).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
                    return KeyResult.FAIL;
                }
            } else {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)key));
                if (item != class_1802.field_8162 && !itemStack.method_31574(item)) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.cobblemonraiddens.raid.no_unique_key", (Object[])new Object[]{item.method_7854().method_7964()}).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
                    return KeyResult.FAIL;
                }
            }
            return KeyResult.CONSUME;
        }
        if (CRDBroadcasts.CONFIG.requires_remote_key && !ItemValidator.isRemoteKey(itemStack)) {
            player.method_43496((class_2561)class_2561.method_43470((String)CRDBroadcasts.CONFIG.no_key_message).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
            return KeyResult.FAIL;
        }
        if (CRDBroadcasts.CONFIG.requires_remote_key) {
            return KeyResult.CONSUME;
        }
        if (blockEntity.isOpen()) {
            return KeyResult.SUCCESS;
        }
        if (((TierConfig)CobblemonRaidDens.TIER_CONFIG.get(boss.getTier())).requiresKey() && !RaidUtils.isRaidDenKey((class_1799)itemStack)) {
            player.method_43496(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.no_key"));
            return KeyResult.FAIL;
        }
        return KeyResult.CONSUME;
    }
}

