/*
 * Decompiled with CFR 0.152.
 */
package necro.crd.broadcasts.common.handler;

import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import necro.crd.broadcasts.common.CRDBroadcasts;
import necro.crd.broadcasts.common.util.AnnounceMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class AnnouncementHandler {
    public static Unit handle(RaidDenSpawnEvent event) {
        if (CRDBroadcasts.CONFIG.spawn_announcements == AnnounceMode.NONE) {
            return Unit.INSTANCE;
        }
        if (event.getRaidBoss().getDisplayAspects() == null) {
            event.getRaidBoss().createDisplayAspects();
        }
        MutableComponent message = Component.literal((String)CRDBroadcasts.CONFIG.announcement_message.replace("%BOSS%", event.getRaidBoss().getDisplaySpecies().getTranslatedName().getString()).replace("%POS%", "[" + event.getBlockPos().toShortString() + "]").replace("%BIOME%", Component.translatable((String)("biome." + ((ResourceKey)event.getLevel().getBiome(event.getBlockPos()).unwrapKey().orElseThrow()).location().toString().replace(":", "."))).getString()));
        List<ServerPlayer> players = switch (CRDBroadcasts.CONFIG.spawn_announcements) {
            case AnnounceMode.RANGE -> AnnouncementHandler.getInRange(event.getLevel(), event.getBlockPos());
            case AnnounceMode.DIMENSION -> AnnouncementHandler.getInDimension(event.getLevel());
            case AnnounceMode.SERVER -> AnnouncementHandler.getAll(event.getLevel());
            default -> throw new RuntimeException("Raid spawn announcements are forbidden!");
        };
        AnnouncementHandler.sendMessage(players, (Component)message);
        return Unit.INSTANCE;
    }

    private static List<ServerPlayer> getInRange(ServerLevel level, BlockPos blockPos) {
        return level.getPlayers(player -> player.blockPosition().distSqr((Vec3i)blockPos) <= (double)(CRDBroadcasts.CONFIG.range * CRDBroadcasts.CONFIG.range));
    }

    private static List<ServerPlayer> getInDimension(ServerLevel level) {
        return level.players();
    }

    private static List<ServerPlayer> getAll(ServerLevel level) {
        return level.getServer().getPlayerList().getPlayers();
    }

    private static void sendMessage(Collection<ServerPlayer> players, Component message) {
        players.forEach(p -> p.sendSystemMessage(message));
    }
}

