/*
 * Decompiled with CFR 0.152.
 */
package necro.crd.broadcasts.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RequestHandler;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.List;
import java.util.UUID;
import necro.crd.broadcasts.common.CRDBroadcasts;
import necro.crd.broadcasts.common.handler.PlayerHandler;
import necro.crd.broadcasts.common.util.AnnounceMode;
import necro.crd.broadcasts.common.util.ItemValidator;
import necro.crd.broadcasts.common.util.KeyResult;
import necro.crd.broadcasts.common.util.MessageBuilder;
import necro.crd.broadcasts.common.util.RaidBroadcasts;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BroadcastCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"crd").then(((LiteralArgumentBuilder)Commands.literal((String)"broadcast").requires(source -> source.isPlayer() && CRDBroadcasts.CONFIG.enable_broadcast != AnnounceMode.NONE)).executes(BroadcastCommands::broadcast))).then(((LiteralArgumentBuilder)Commands.literal((String)"invite").requires(source -> source.isPlayer() && CRDBroadcasts.CONFIG.enable_invite)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(BroadcastCommands::invite)))).then(((LiteralArgumentBuilder)Commands.literal((String)"request").requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"host", (ArgumentType)EntityArgument.player()).executes(BroadcastCommands::request))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        BroadcastCommands.register(dispatcher);
    }

    private static int broadcast(CommandContext<CommandSourceStack> context) {
        ServerPlayer host = ((CommandSourceStack)context.getSource()).getPlayer();
        if (host == null) {
            return 0;
        }
        if (!RaidHelper.isAlreadyHosting((Player)host)) {
            return 0;
        }
        RequestHandler handler = RaidHelper.getRequest((ServerPlayer)host);
        if (handler == null) {
            return 0;
        }
        RaidBroadcasts.BROADCASTED.put(host.getUUID(), 0);
        List players = switch (CRDBroadcasts.CONFIG.enable_broadcast) {
            default -> throw new MatchException(null, null);
            case AnnounceMode.NONE -> List.of();
            case AnnounceMode.RANGE -> PlayerHandler.getInRange((ServerLevel)handler.getBlockEntity().getLevel(), handler.getBlockEntity().getBlockPos(), CRDBroadcasts.CONFIG.broadcast_range);
            case AnnounceMode.DIMENSION -> PlayerHandler.getInDimension((ServerLevel)handler.getBlockEntity().getLevel());
            case AnnounceMode.SERVER -> PlayerHandler.getAll((ServerLevel)handler.getBlockEntity().getLevel());
        };
        players.forEach(p -> p.sendSystemMessage(MessageBuilder.broadcast(host, handler.getBlockEntity().getRaidBoss())));
        return 1;
    }

    private static int invite(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer host = ((CommandSourceStack)context.getSource()).getPlayer();
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        if (host == null) {
            return 0;
        }
        if (!RaidHelper.isAlreadyHosting((Player)host)) {
            return 0;
        }
        if (host == player) {
            return 0;
        }
        RequestHandler handler = RaidHelper.getRequest((ServerPlayer)host);
        if (handler == null) {
            return 0;
        }
        RaidBroadcasts.INVITED.add(player.getUUID());
        player.sendSystemMessage(MessageBuilder.invite(host, handler.getBlockEntity().getRaidBoss()));
        return 1;
    }

    private static int request(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        ServerPlayer host = EntityArgument.getPlayer(context, (String)"host");
        RequestHandler handler = RaidHelper.getRequest((ServerPlayer)host);
        if (handler == null) {
            return 0;
        }
        RaidCrystalBlockEntity blockEntity = handler.getBlockEntity();
        if (!RaidBroadcasts.BROADCASTED.containsKey(host.getUUID()) && !RaidBroadcasts.INVITED.contains(player.getUUID())) {
            return 0;
        }
        RaidBroadcasts.INVITED.remove(player.getUUID());
        if (!RaidHelper.isAlreadyHosting((Player)host)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.already_hosting"));
            return 0;
        }
        if (RaidHelper.isAlreadyParticipating((Player)player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.already_participating"));
            return 0;
        }
        if (RaidHelper.isInQueue((Player)player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.already_in_queue"));
            return 0;
        }
        if (RaidHelper.hasClearedRaid((UUID)blockEntity.getUuid(), (Player)player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.player_cleared"));
            return 0;
        }
        if (blockEntity.isFull()) {
            player.sendSystemMessage(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.lobby_is_full"));
            return 0;
        }
        ItemStack itemStack = player.getMainHandItem();
        KeyResult result = BroadcastCommands.handleKey(blockEntity, player, itemStack);
        if (result == KeyResult.FAIL) {
            return 0;
        }
        RaidHelper.addToQueue((Player)player, (ItemStack)(result == KeyResult.CONSUME ? itemStack : null));
        if (result == KeyResult.CONSUME) {
            itemStack.consume(1, (LivingEntity)player);
        }
        RaidHelper.addRequest((ServerPlayer)host, (Player)player);
        RaidDenNetworkMessages.REQUEST_PACKET.accept(host, player.getName().getString());
        RaidBroadcasts.BROADCASTED.computeIfPresent(host.getUUID(), (uuid, requests) -> {
            requests = requests + 1;
            return requests;
        });
        if (RaidBroadcasts.BROADCASTED.getOrDefault(host.getUUID(), 0) >= CRDBroadcasts.CONFIG.max_requests) {
            RaidBroadcasts.BROADCASTED.remove(host.getUUID());
        }
        RaidBroadcasts.REMOTERS.put(player.getUUID(), player.position());
        return 1;
    }

    private static KeyResult handleKey(RaidCrystalBlockEntity blockEntity, ServerPlayer player, ItemStack itemStack) {
        RaidBoss boss = blockEntity.getRaidBoss();
        String key = boss.getKey();
        if (!((TierConfig)CobblemonRaidDens.TIER_CONFIG.get(boss.getTier())).requiresKey() && key.isEmpty() && !CRDBroadcasts.CONFIG.requires_remote_key) {
            return KeyResult.SUCCESS;
        }
        if (((TierConfig)CobblemonRaidDens.TIER_CONFIG.get(boss.getTier())).allRequireUniqueKey() && !key.isEmpty()) {
            if (key.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)key.substring(1)));
                if (!itemStack.is(tag)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.no_unique_key", (Object[])new Object[]{key.split(":")[1]}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
                    return KeyResult.FAIL;
                }
            } else {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)key));
                if (item != Items.AIR && !itemStack.is(item)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.no_unique_key", (Object[])new Object[]{item.getDefaultInstance().getHoverName()}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
                    return KeyResult.FAIL;
                }
            }
            return KeyResult.CONSUME;
        }
        if (CRDBroadcasts.CONFIG.requires_remote_key && !ItemValidator.isRemoteKey(itemStack)) {
            player.sendSystemMessage((Component)Component.literal((String)CRDBroadcasts.CONFIG.no_key_message).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            return KeyResult.FAIL;
        }
        if (CRDBroadcasts.CONFIG.requires_remote_key) {
            return KeyResult.CONSUME;
        }
        if (blockEntity.isOpen()) {
            return KeyResult.SUCCESS;
        }
        if (((TierConfig)CobblemonRaidDens.TIER_CONFIG.get(boss.getTier())).requiresKey() && !RaidUtils.isRaidDenKey((ItemStack)itemStack)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage((String)"message.cobblemonraiddens.raid.no_key"));
            return KeyResult.FAIL;
        }
        return KeyResult.CONSUME;
    }
}

