/*
 * Decompiled with CFR 0.152.
 */
package necro.crd.broadcasts.common.handler;

import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import necro.crd.broadcasts.common.CRDBroadcasts;
import necro.crd.broadcasts.common.handler.PlayerHandler;
import necro.crd.broadcasts.common.util.AnnounceMode;
import necro.crd.broadcasts.common.util.ComponentManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;

public class AnnouncementHandler {
    public static Unit handle(RaidDenSpawnEvent event) {
        if (CRDBroadcasts.CONFIG.spawn_announcements == AnnounceMode.NONE) {
            return Unit.INSTANCE;
        }
        if (event.getRaidBoss().getTier().ordinal() < CRDBroadcasts.CONFIG.min_tier.ordinal()) {
            return Unit.INSTANCE;
        }
        if (event.getRaidBoss().getDisplayAspects() == null) {
            event.getRaidBoss().createDisplayAspects();
        }
        Component message = ComponentManager.format(CRDBroadcasts.CONFIG.announcement_message.replace("%TIER%", event.getRaidBoss().getTier().getStars()).replace("%BOSS%", event.getRaidBoss().getDisplaySpecies().getTranslatedName().getString()).replace("%POS%", "[" + event.getBlockPos().toShortString() + "]").replace("%BIOME%", Component.translatable((String)("biome." + ((ResourceKey)event.getLevel().getBiome(event.getBlockPos()).unwrapKey().orElseThrow()).location().toString().replace(":", "."))).getString()));
        List<ServerPlayer> players = switch (CRDBroadcasts.CONFIG.spawn_announcements) {
            case AnnounceMode.RANGE -> PlayerHandler.getInRange(event.getLevel(), event.getBlockPos(), CRDBroadcasts.CONFIG.announcement_range);
            case AnnounceMode.DIMENSION -> PlayerHandler.getInDimension(event.getLevel());
            case AnnounceMode.SERVER -> PlayerHandler.getAll(event.getLevel());
            default -> throw new RuntimeException("Raid spawn announcements are forbidden!");
        };
        AnnouncementHandler.sendMessage(players, message);
        return Unit.INSTANCE;
    }

    private static void sendMessage(Collection<ServerPlayer> players, Component message) {
        players.forEach(p -> p.sendSystemMessage(message));
    }
}

