/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecraftmods.mdm.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GreenCurtainBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> FACE = FaceAttachedHorizontalDirectionalBlock.FACE;

    public GreenCurtainBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.WOOL).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.WALL));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield GreenCurtainBlock.box((double)-4.0, (double)-16.0, (double)0.0, (double)20.0, (double)32.0, (double)2.0);
                    }
                    case WALL: {
                        yield GreenCurtainBlock.box((double)-4.0, (double)14.0, (double)-16.0, (double)20.0, (double)16.0, (double)32.0);
                    }
                    case CEILING: 
                }
                yield GreenCurtainBlock.box((double)-4.0, (double)-16.0, (double)0.0, (double)20.0, (double)32.0, (double)2.0);
            }
            case Direction.NORTH -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield GreenCurtainBlock.box((double)-4.0, (double)-16.0, (double)14.0, (double)20.0, (double)32.0, (double)16.0);
                    }
                    case WALL: {
                        yield GreenCurtainBlock.box((double)-4.0, (double)14.0, (double)-16.0, (double)20.0, (double)16.0, (double)32.0);
                    }
                    case CEILING: 
                }
                yield GreenCurtainBlock.box((double)-4.0, (double)-16.0, (double)14.0, (double)20.0, (double)32.0, (double)16.0);
            }
            case Direction.EAST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield GreenCurtainBlock.box((double)0.0, (double)-16.0, (double)-4.0, (double)2.0, (double)32.0, (double)20.0);
                    }
                    case WALL: {
                        yield GreenCurtainBlock.box((double)-16.0, (double)14.0, (double)-4.0, (double)32.0, (double)16.0, (double)20.0);
                    }
                    case CEILING: 
                }
                yield GreenCurtainBlock.box((double)0.0, (double)-16.0, (double)-4.0, (double)2.0, (double)32.0, (double)20.0);
            }
            case Direction.WEST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield GreenCurtainBlock.box((double)14.0, (double)-16.0, (double)-4.0, (double)16.0, (double)32.0, (double)20.0);
                    }
                    case WALL: {
                        yield GreenCurtainBlock.box((double)-16.0, (double)14.0, (double)-4.0, (double)32.0, (double)16.0, (double)20.0);
                    }
                    case CEILING: 
                }
                yield GreenCurtainBlock.box((double)14.0, (double)-16.0, (double)-4.0, (double)16.0, (double)32.0, (double)20.0);
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)this.faceForDirection(context.getNearestLookingDirection()))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private AttachFace faceForDirection(Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR;
        }
        return AttachFace.WALL;
    }
}

