/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecraftmods.mdm.init;

import com.cookiecraftmods.mdm.MdmMod;
import com.cookiecraftmods.mdm.init.MdmModScreens;
import com.cookiecraftmods.mdm.network.MenuStateUpdateMessage;
import com.cookiecraftmods.mdm.world.inventory.FreezerguiMenu;
import com.cookiecraftmods.mdm.world.inventory.FridgeGuiMenu;
import com.cookiecraftmods.mdm.world.inventory.OvenGuiMenu;
import com.cookiecraftmods.mdm.world.inventory.StorageMenu;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MdmModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"mdm");
    public static final RegistryObject<MenuType<StorageMenu>> STORAGE = REGISTRY.register("storage", () -> IForgeContainerType.create(StorageMenu::new));
    public static final RegistryObject<MenuType<FreezerguiMenu>> FREEZERGUI = REGISTRY.register("freezergui", () -> IForgeContainerType.create(FreezerguiMenu::new));
    public static final RegistryObject<MenuType<FridgeGuiMenu>> FRIDGE_GUI = REGISTRY.register("fridge_gui", () -> IForgeContainerType.create(FridgeGuiMenu::new));
    public static final RegistryObject<MenuType<OvenGuiMenu>> OVEN_GUI = REGISTRY.register("oven_gui", () -> IForgeContainerType.create(OvenGuiMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            Player player2 = player;
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                MdmMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.f_19853_.f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof MdmModScreens.ScreenAccessor) {
                    MdmModScreens.ScreenAccessor accessor = (MdmModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                MdmMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

