/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CopyEnchantmentsLootModifier
extends LootModifier {
    public static final Supplier<Codec<CopyEnchantmentsLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, CopyEnchantmentsLootModifier::new)));

    public CopyEnchantmentsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> drops, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81462_) || !context.m_78936_(LootContextParams.f_81461_)) {
            return drops;
        }
        BlockState blockState = (BlockState)context.m_165124_(LootContextParams.f_81461_);
        BlockEntity tileEntity = (BlockEntity)context.m_165124_(LootContextParams.f_81462_);
        CompoundTag tileStackNbt = tileEntity.getPersistentData().m_128469_("shulker_enchantments:PersistedItemNbt");
        if (tileStackNbt.m_128456_()) {
            return drops;
        }
        for (ItemStack drop : drops) {
            BlockItem blockItem;
            Item item = drop.m_41720_();
            if (!(item instanceof BlockItem) || !(blockItem = (BlockItem)item).m_40614_().equals(blockState.m_60734_())) continue;
            CompoundTag existingTag = drop.m_41783_();
            if (existingTag == null) {
                drop.m_41751_(tileStackNbt.m_6426_());
                continue;
            }
            drop.m_41751_(existingTag.m_128391_(tileStackNbt));
        }
        return drops;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

