/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments;

import be.ephys.shulker_enchantments.Tags;
import be.ephys.shulker_enchantments.capabilities.BlockItemStackItemHandlerProvider;
import be.ephys.shulker_enchantments.capabilities.SeedPouchItemHandlerProvider;
import be.ephys.shulker_enchantments.refill.RefillEnchantment;
import be.ephys.shulker_enchantments.siphon.SiphonEnchantment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="shulker_enchantments", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEnchantments {
    public static final EnchantmentCategory SHULKER_LIKE = EnchantmentCategory.create((String)"shulker_like", Tags::isShulkerLike);
    public static final SiphonEnchantment SIPHON = new SiphonEnchantment();
    public static final RefillEnchantment REFILL = new RefillEnchantment();
    public static final RegistryObject<Item> QUARK_SEED_POUCH = RegistryObject.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"seed_pouch"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final ResourceLocation BLOCK_ITEM_HANDLER_CAPABILITY_ID = ResourceLocation.fromNamespaceAndPath((String)"shulker_enchantments", (String)"block_item_item_handler");
    public static final ResourceLocation SEED_POUCH_ITEM_HANDLER_CAPABILITY_ID = ResourceLocation.fromNamespaceAndPath((String)"shulker_enchantments", (String)"seed_pouch_item_handler");

    @SubscribeEvent
    public static void registerEnchantments(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ENCHANTMENTS, helper -> {
            helper.register(ResourceLocation.fromNamespaceAndPath((String)"shulker_enchantments", (String)"siphon"), (Object)SIPHON);
            helper.register(ResourceLocation.fromNamespaceAndPath((String)"shulker_enchantments", (String)"refill"), (Object)REFILL);
        });
        MinecraftForge.EVENT_BUS.addListener(SIPHON::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, SIPHON::onItemUseFinish);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, ModEnchantments::onAttachItemStackCapabilities);
    }

    public static void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (QUARK_SEED_POUCH.isPresent() && stack.m_150930_((Item)QUARK_SEED_POUCH.get())) {
            if (event.getCapabilities().containsKey(SEED_POUCH_ITEM_HANDLER_CAPABILITY_ID)) {
                return;
            }
            event.addCapability(SEED_POUCH_ITEM_HANDLER_CAPABILITY_ID, (ICapabilityProvider)new SeedPouchItemHandlerProvider(stack));
            return;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.m_40614_() instanceof ShulkerBoxBlock) && !(blockItem.m_40614_() instanceof EnderChestBlock)) {
            return;
        }
        if (event.getCapabilities().containsKey(BLOCK_ITEM_HANDLER_CAPABILITY_ID)) {
            return;
        }
        event.addCapability(BLOCK_ITEM_HANDLER_CAPABILITY_ID, (ICapabilityProvider)new BlockItemStackItemHandlerProvider(stack));
    }
}

