/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.capabilities;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BlockItemStackItemHandler
extends ItemStackHandler {
    private final ItemStack itemStack;
    private final int maxStackSize;
    public static final String BLOCK_ENTITY_TAG = "BlockEntityTag";

    public BlockItemStackItemHandler(ItemStack itemStack, int slotCount, int maxStackSize) {
        super(slotCount);
        this.itemStack = itemStack;
        this.maxStackSize = maxStackSize;
        CompoundTag nbt = itemStack.m_41737_(BLOCK_ENTITY_TAG);
        if (nbt != null) {
            this.deserializeNBT(nbt);
        }
    }

    public int getSlotLimit(int slot) {
        return this.maxStackSize;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = this.itemStack.m_41737_(BLOCK_ENTITY_TAG);
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        ContainerHelper.m_18976_((CompoundTag)nbt, (NonNullList)this.stacks, (boolean)true);
        return nbt;
    }

    protected void onContentsChanged(int slot) {
        CompoundTag newChildNbt = this.serializeNBT();
        CompoundTag nbt = this.itemStack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128365_(BLOCK_ENTITY_TAG, (Tag)newChildNbt);
        this.itemStack.m_41751_(nbt);
    }
}

