/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.capabilities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class SeedPouchItemHandler
extends ItemStackHandler {
    private final ItemStack stack;

    public SeedPouchItemHandler(ItemStack stack) {
        super(10);
        this.stack = stack;
        this.deserializeNBT(this.stack.m_41783_());
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.writeNBT(nbt);
        return nbt;
    }

    private void writeNBT(CompoundTag nbt) {
        ItemStack storedItem = ItemStack.f_41583_;
        int itemCount = 0;
        for (int i = 0; i < 10; ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.m_41619_()) continue;
            if (storedItem.m_41619_()) {
                storedItem = stack;
            }
            itemCount += stack.m_41613_();
        }
        if (itemCount == 0) {
            nbt.m_128473_("storedItem");
            nbt.m_128473_("itemCount");
        } else {
            CompoundTag storedItemNbt = storedItem.m_41739_(new CompoundTag());
            storedItemNbt.m_128405_("Count", 1);
            nbt.m_128365_("storedItem", (Tag)storedItemNbt);
            nbt.m_128405_("itemCount", itemCount);
        }
    }

    public void deserializeNBT(CompoundTag nbt) {
        int i;
        if (nbt == null) {
            return;
        }
        if (!nbt.m_128441_("storedItem")) {
            this.setSize(10);
            return;
        }
        CompoundTag storedItemNbt = nbt.m_128469_("storedItem");
        ItemStack storedItem = ItemStack.m_41712_((CompoundTag)storedItemNbt);
        int itemCount = nbt.m_128451_("itemCount");
        int fullStackCount = itemCount / 64;
        int lastStackContents = itemCount % 64;
        for (i = 0; i < fullStackCount; ++i) {
            ItemStack stack = storedItem.m_41777_();
            stack.m_41764_(64);
            this.stacks.set(i, (Object)stack);
        }
        if (fullStackCount < 10) {
            if (lastStackContents == 0) {
                this.stacks.set(fullStackCount, (Object)ItemStack.f_41583_);
            } else {
                ItemStack stack = storedItem.m_41777_();
                stack.m_41764_(lastStackContents);
                this.stacks.set(fullStackCount, (Object)stack);
            }
            for (i = fullStackCount + 1; i < 10; ++i) {
                this.stacks.set(i, (Object)ItemStack.f_41583_);
            }
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        CompoundTag nbt = this.stack.m_41784_();
        this.writeNBT(nbt);
        int itemCount = nbt.m_128451_("itemCount");
        if (itemCount == 0) {
            this.stack.m_41721_(0);
        } else {
            this.stack.m_41721_(641 - itemCount);
        }
    }
}

