/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.helpers;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ModInventoryHelper {
    public static boolean isCuriosInstalled() {
        return ModList.get().isLoaded("curios");
    }

    public static Iterable<ItemStack> getInventoryItems(LivingEntity entity) {
        Optional out;
        IItemHandlerIterable inventoryIterator = null;
        IItemHandlerIterable curiosIterator = null;
        Optional itemHandlerCapability = entity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerCapability.isPresent()) {
            inventoryIterator = new IItemHandlerIterable((IItemHandler)itemHandlerCapability.get());
        }
        if (ModInventoryHelper.isCuriosInstalled() && (out = CuriosApi.getCuriosInventory((LivingEntity)entity).resolve()).isPresent()) {
            curiosIterator = new IItemHandlerIterable((IItemHandler)((ICuriosItemHandler)out.get()).getEquippedCurios());
        }
        if (inventoryIterator == null && curiosIterator == null) {
            return new ArrayList<ItemStack>();
        }
        if (inventoryIterator == null) {
            return curiosIterator;
        }
        if (curiosIterator == null) {
            return inventoryIterator;
        }
        return Iterables.concat((Iterable)inventoryIterator, curiosIterator);
    }

    public static boolean areItemStacksEqual(ItemStack a, ItemStack b) {
        return a.m_41619_() && b.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b);
    }

    public static class IItemHandlerIterable
    implements Iterable<ItemStack> {
        private final IItemHandler itemHandler;

        public IItemHandlerIterable(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return new IItemHandlerIterator(this.itemHandler);
        }
    }

    public static class IItemHandlerIterator
    implements Iterator<ItemStack> {
        private final IItemHandler itemHandler;
        private int nextIndex = 0;

        public IItemHandlerIterator(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.itemHandler.getSlots();
        }

        @Override
        public ItemStack next() {
            return this.itemHandler.getStackInSlot(this.nextIndex++);
        }
    }

    public static class EmptyIterator<T>
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new RuntimeException("Iterator is empty");
        }
    }
}

