/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.refill;

import be.ephys.shulker_enchantments.core.ModNetworking;
import be.ephys.shulker_enchantments.helpers.ModInventoryHelper;
import be.ephys.shulker_enchantments.refill.RefillConfig;
import be.ephys.shulker_enchantments.refill.RequestRefillNetworkMessage;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="shulker_enchantments", value={Dist.CLIENT})
public class RefillClientEvents {
    private static boolean trackingReset = false;
    private static final ItemStack[] previousInventory = new ItemStack[41];

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        RefillConfig.RefillScope refillScope;
        if (event.side != LogicalSide.CLIENT) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            if (!trackingReset) {
                trackingReset = true;
                Arrays.fill(previousInventory, ItemStack.f_41583_);
            }
            return;
        }
        trackingReset = false;
        Player player = event.player;
        if (((Boolean)RefillConfig.refillOffhand.get()).booleanValue()) {
            RefillClientEvents.checkRefill(player, 40);
        }
        if ((refillScope = (RefillConfig.RefillScope)((Object)RefillConfig.refillScope.get())) == RefillConfig.RefillScope.HAND) {
            RefillClientEvents.checkRefill(player, player.m_150109_().f_35977_);
        } else {
            int watchedInventorySize = RefillConfig.refillScope.get() == RefillConfig.RefillScope.HOTBAR ? 9 : 36;
            for (int i = 0; i < watchedInventorySize; ++i) {
                RefillClientEvents.checkRefill(player, i);
            }
        }
    }

    private static void checkRefill(Player player, int slot) {
        int previousStackSize;
        boolean wasEmptied;
        ItemStack currentStack = player.m_150109_().m_8020_(slot);
        ItemStack previousStack = previousInventory[slot];
        boolean bl = wasEmptied = !previousStack.m_41619_() && currentStack.m_41619_();
        if (!wasEmptied && !ModInventoryHelper.areItemStacksEqual(currentStack, previousStack)) {
            RefillClientEvents.previousInventory[slot] = currentStack.m_41777_();
            return;
        }
        int newStackSize = currentStack.m_41613_();
        if (newStackSize < (previousStackSize = previousStack.m_41613_()) && RefillConfig.canBeRefilled(previousStack)) {
            RefillClientEvents.requestRefill((byte)slot, previousStack, previousStackSize - newStackSize);
        }
        previousStack.m_41764_(newStackSize);
    }

    private static void requestRefill(byte inventorySlot, ItemStack itemStackTemplate, int requestedAmount) {
        ModNetworking.INSTANCE.sendToServer((Object)new RequestRefillNetworkMessage(inventorySlot, itemStackTemplate, requestedAmount));
    }

    static {
        Arrays.fill(previousInventory, ItemStack.f_41583_);
    }
}

