/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.refill;

import be.ephys.cookiecore.config.Config;
import be.ephys.shulker_enchantments.Tags;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class RefillConfig {
    @Config(name="refill_offhand", side=ModConfig.Type.SERVER, description="Refill the offhand slot")
    @Config.BooleanDefault(value=true)
    public static ForgeConfigSpec.BooleanValue refillOffhand;
    @Config(name="refill_scope", side=ModConfig.Type.SERVER, description="Which parts of the inventory are refilled:\n- HAND: Only active hand (+ offhand if refill_offhand is true),\n- HOTBAR: The entire hotbar (+ offhand if refill_offhand is true),\n- INVENTORY: The entire 36-slot inventory (+ offhand if refill_offhand is true)")
    @Config.EnumDefault(value="HOTBAR", enumType=RefillScope.class)
    public static ForgeConfigSpec.EnumValue<RefillScope> refillScope;
    @Config(name="refill_non_stackables", side=ModConfig.Type.SERVER, description="Refill non-stackable items (like the totem of undying). You can also ban specific items by adding them to the shulker_enchantments:non_refillable item tag.")
    @Config.BooleanDefault(value=false)
    public static ForgeConfigSpec.BooleanValue refillNonStackables;

    public static boolean canBeRefilled(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_204117_(Tags.TAG_NON_REFILLABLE)) {
            return false;
        }
        return (Boolean)refillNonStackables.get() != false || stack.m_41753_();
    }

    static enum RefillScope {
        HAND,
        HOTBAR,
        INVENTORY;

    }
}

