/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.refill;

import be.ephys.shulker_enchantments.ModEnchantments;
import be.ephys.shulker_enchantments.Tags;
import be.ephys.shulker_enchantments.core.Mod;
import be.ephys.shulker_enchantments.helpers.ModInventoryHelper;
import be.ephys.shulker_enchantments.refill.RefillConfig;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class RefillHandler {
    public static void attemptRefill(Player player, int inventorySlot, ItemStack itemTemplate, int requestedAmount) {
        ItemStack newStack;
        if (player.m_5833_()) {
            return;
        }
        if (!RefillConfig.canBeRefilled(itemTemplate)) {
            return;
        }
        if (inventorySlot == 40 && !((Boolean)RefillConfig.refillOffhand.get()).booleanValue()) {
            return;
        }
        ItemStack currentStack = player.m_150109_().m_8020_(inventorySlot);
        requestedAmount = Math.min(requestedAmount, itemTemplate.m_41741_() - currentStack.m_41613_());
        if (!currentStack.m_41619_() && !ModInventoryHelper.areItemStacksEqual(itemTemplate, currentStack)) {
            return;
        }
        int foundAmount = 0;
        for (ItemStack invStack : ModInventoryHelper.getInventoryItems((LivingEntity)player)) {
            InvWrapper itemHandler;
            if (foundAmount >= requestedAmount) break;
            if (EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.REFILL, (ItemStack)invStack) == 0) continue;
            if (Tags.isEnderChest(invStack)) {
                itemHandler = new InvWrapper((Container)player.m_36327_());
            } else {
                Optional optionalItemHandler = invStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
                if (!optionalItemHandler.isPresent()) {
                    Mod.LOG.error("Item " + String.valueOf(invStack.m_41720_()) + " is enchanted with refill but does not have an item handler");
                    continue;
                }
                itemHandler = (IItemHandler)optionalItemHandler.get();
            }
            int missingAmount = requestedAmount - foundAmount;
            ItemStack extractedStack = RefillHandler.extractItem((IItemHandler)itemHandler, itemTemplate, missingAmount);
            foundAmount += extractedStack.m_41613_();
        }
        if (foundAmount == 0) {
            return;
        }
        if (currentStack.m_41619_()) {
            newStack = itemTemplate.m_41777_();
            newStack.m_41764_(foundAmount);
        } else {
            newStack = currentStack.m_41777_();
            newStack.m_41764_(currentStack.m_41613_() + foundAmount);
        }
        player.f_36096_.m_38946_();
        player.m_150109_().m_6836_(inventorySlot, newStack);
        player.f_36096_.m_38946_();
    }

    private static ItemStack extractItem(IItemHandler inventory, ItemStack itemTemplate, int requestedAmount) {
        ItemStack output = itemTemplate.m_41777_();
        output.m_41764_(0);
        for (int i = 0; i < inventory.getSlots() && output.m_41613_() < requestedAmount; ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inventory.getStackInSlot(i), (ItemStack)itemTemplate)) continue;
            int missingAmount = requestedAmount - output.m_41613_();
            ItemStack extracted = inventory.extractItem(i, missingAmount, false);
            output.m_41764_(output.m_41613_() + extracted.m_41613_());
        }
        return output;
    }
}

