/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.refill;

import be.ephys.shulker_enchantments.core.ModNetworking;
import be.ephys.shulker_enchantments.refill.RefillHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(modid="shulker_enchantments", bus=Mod.EventBusSubscriber.Bus.MOD)
public record RequestRefillNetworkMessage(byte inventorySlot, ItemStack itemStackTemplate, int requestedAmount) {
    @SubscribeEvent
    public static void registerPacket(FMLCommonSetupEvent event) {
        ModNetworking.INSTANCE.registerMessage(ModNetworking.REQUEST_REFILL_DISCRIMINATOR, RequestRefillNetworkMessage.class, RequestRefillNetworkMessage::encode, RequestRefillNetworkMessage::decode, RequestRefillNetworkMessage::handle);
    }

    public static void encode(RequestRefillNetworkMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.inventorySlot);
        buffer.writeItemStack(message.itemStackTemplate, false);
        buffer.writeInt(message.requestedAmount);
    }

    public static RequestRefillNetworkMessage decode(FriendlyByteBuf buffer) {
        return new RequestRefillNetworkMessage(buffer.readByte(), buffer.m_130267_(), buffer.readInt());
    }

    public static void handle(RequestRefillNetworkMessage packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            RefillHandler.attemptRefill((Player)player, packet.inventorySlot, packet.itemStackTemplate, packet.requestedAmount);
        });
        context.get().setPacketHandled(true);
    }
}

