/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.shulker_enchantments.siphon;

import be.ephys.cookiecore.config.Config;
import be.ephys.shulker_enchantments.ModEnchantments;
import be.ephys.shulker_enchantments.Tags;
import be.ephys.shulker_enchantments.core.Mod;
import be.ephys.shulker_enchantments.helpers.ModInventoryHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SiphonEnchantment
extends Enchantment {
    @Config(name="siphon_on_consume", side=ModConfig.Type.SERVER, description="Siphon items produced by consuming items (such as milk buckets, bottles, etc.)")
    @Config.BooleanDefault(value=true)
    public static ForgeConfigSpec.BooleanValue siphonOnConsume;

    public SiphonEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantments.SHULKER_LIKE, new EquipmentSlot[0]);
        this.f_44673_ = "enchantment.shulker_enchantments.siphon";
    }

    public boolean m_6081_(ItemStack stack) {
        return Tags.isShulkerLike(stack) || Tags.isEnderChest(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public boolean m_6591_() {
        return true;
    }

    public int m_6183_(int enchantmentLevel) {
        return enchantmentLevel * 25;
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 50;
    }

    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!((Boolean)siphonOnConsume.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack sourceStack = event.getItem();
        ItemStack resultStack = event.getResultStack();
        if (sourceStack == resultStack) {
            return;
        }
        int totalPickedUp = this.siphonItem(player, resultStack);
        if (totalPickedUp > 0) {
            resultStack.m_41764_(resultStack.m_41613_() - totalPickedUp);
            player.m_150109_().m_6596_();
        }
    }

    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        ItemEntity itemEntity = event.getItem();
        ItemStack pickedItemStack = itemEntity.m_32055_();
        Player player = event.getEntity();
        int totalPickedUp = this.siphonItem(player, pickedItemStack);
        if (totalPickedUp > 0) {
            event.setCanceled(true);
            pickedItemStack.m_41764_(pickedItemStack.m_41613_() - totalPickedUp);
            player.m_150109_().m_6596_();
            if (!itemEntity.m_20067_()) {
                itemEntity.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((itemEntity.m_9236_().f_46441_.m_188501_() - itemEntity.m_9236_().f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundTakeItemEntityPacket(event.getItem().m_19879_(), player.m_19879_(), totalPickedUp));
            player.f_36096_.m_38946_();
        }
    }

    public int siphonItem(Player player, ItemStack pickedItemStack) {
        ItemStack initialItemStack = pickedItemStack;
        for (ItemStack invStack : ModInventoryHelper.getInventoryItems((LivingEntity)player)) {
            InvWrapper itemHandler;
            if (pickedItemStack.m_41619_()) break;
            if (invStack.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.SIPHON, (ItemStack)invStack) == 0) continue;
            if (Tags.isEnderChest(invStack)) {
                itemHandler = new InvWrapper((Container)player.m_36327_());
            } else {
                Optional optionalItemHandler = invStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
                if (optionalItemHandler.isEmpty()) {
                    Mod.LOG.error("Item " + String.valueOf(invStack.m_41720_()) + " is enchanted with siphon but does not have an item handler");
                    continue;
                }
                itemHandler = (IItemHandler)optionalItemHandler.get();
            }
            if (!SiphonEnchantment.hasItem((IItemHandler)itemHandler, pickedItemStack)) continue;
            pickedItemStack = pickedItemStack.m_41777_();
            pickedItemStack = SiphonEnchantment.addStackToExistingStacksOnly((IItemHandler)player.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().get(), pickedItemStack, false);
            if (pickedItemStack.m_41619_()) continue;
            pickedItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)pickedItemStack, (boolean)false);
        }
        int totalPickedUp = initialItemStack.m_41613_() - pickedItemStack.m_41613_();
        return totalPickedUp;
    }

    public static ItemStack addStackToExistingStacksOnly(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate) {
        for (int i = 0; !(i >= inventory.getSlots() || ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)inventory.getStackInSlot(i), (ItemStack)stack) && (stack = inventory.insertItem(i, stack, simulate)).m_41619_()); ++i) {
        }
        return stack;
    }

    public static boolean hasItem(IItemHandler itemHandler, ItemStack itemStack) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemHandler.getStackInSlot(i), (ItemStack)itemStack)) continue;
            return true;
        }
        return false;
    }
}

