/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.api;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.TaskEnchantmentEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.lib.BaseUtil;
import com.handy.playertask.lib.ItemStackUtil;
import com.handy.playertask.lib.MessageUtil;
import com.handy.playertask.lib.StrUtil;
import com.handy.playertask.lib.TranslationUtil;
import com.handy.playertask.lib.mm.MythicMobUtil;
import com.handy.playertask.service.TaskCoinService;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.DemandReplaceUtil;
import com.handy.playertask.util.SendRewardUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerTaskApi {
    private PlayerTaskApi() {
    }

    public static PlayerTaskApi getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public TaskList findDetailByTaskId(@NotNull Integer taskId) {
        return TaskListService.getInstance().findDetailById(taskId).orElse(null);
    }

    public boolean reward(@NotNull List<Player> playerList, @NotNull List<Integer> taskRewardIdList) {
        SendRewardUtil.getInstance().batchSendReward(playerList, taskRewardIdList);
        return true;
    }

    @Deprecated
    public Integer findAmountByPlayer(@NotNull Player player) {
        return this.findAmountByPlayer(player.getUniqueId());
    }

    @Deprecated
    public Integer findAmountByPlayer(@NotNull String playerName) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().findCoinByPlayer(offlinePlayer.getUniqueId());
    }

    public Integer findAmountByPlayer(@NotNull UUID playerUuid) {
        return TaskCoinService.getInstance().findCoinByPlayer(playerUuid);
    }

    @Deprecated
    public boolean addCoin(@NotNull Player player, @NotNull Integer amount) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(amount);
        return this.addCoin(player.getName(), amount);
    }

    @Deprecated
    public boolean addCoin(@NotNull String playerName, @NotNull Integer amount) {
        Objects.requireNonNull(playerName);
        Objects.requireNonNull(amount);
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().addCoin(offlinePlayer.getUniqueId(), amount);
    }

    public boolean addCoin(@NotNull UUID playerUuid, @NotNull Integer amount) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(amount);
        return TaskCoinService.getInstance().addCoin(playerUuid, amount);
    }

    @Deprecated
    public boolean subtractCoin(@NotNull Player player, @NotNull Integer amount) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(amount);
        return this.subtractCoin(player.getName(), amount);
    }

    @Deprecated
    public boolean subtractCoin(@NotNull String playerName, @NotNull Integer amount) {
        Objects.requireNonNull(playerName);
        Objects.requireNonNull(amount);
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().subtractCoin(offlinePlayer.getUniqueId(), amount);
    }

    public boolean subtractCoin(@NotNull UUID playerUuid, @NotNull Integer amount) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(amount);
        return TaskCoinService.getInstance().subtractCoin(playerUuid, amount);
    }

    @Deprecated
    public boolean setCoin(@NotNull Player player, @NotNull Integer amount) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(amount);
        return this.setCoin(player.getName(), amount);
    }

    @Deprecated
    public boolean setCoin(@NotNull String playerName, @NotNull Integer amount) {
        Objects.requireNonNull(playerName);
        Objects.requireNonNull(amount);
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().set(offlinePlayer.getUniqueId(), amount);
    }

    public boolean setCoin(@NotNull UUID playerUuid, @NotNull Integer amount) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(amount);
        return TaskCoinService.getInstance().set(playerUuid, amount);
    }

    public void sendTaskFinishMsg(@NotNull Player player, @NotNull String taskName) {
        String taskFinishMsg = BaseUtil.getMsgNotColor("taskFinish", "");
        if (StrUtil.isEmpty(taskFinishMsg)) {
            return;
        }
        MessageUtil.sendTitle(player, taskName, taskFinishMsg);
    }

    public void sendTaskManagerMsg(@NotNull Player player, @NotNull String taskName) {
        String taskManagerMsg = BaseUtil.getMsgNotColor("open.taskManager");
        if (StrUtil.isEmpty(taskManagerMsg)) {
            return;
        }
        taskManagerMsg = taskManagerMsg.replace("${taskName}", taskName);
        MessageUtil.sendActionbar(player, BaseUtil.replaceChatColor(taskManagerMsg));
    }

    public void sendCurrentProgressMsg(@NotNull Player player, @NotNull String demandType, @NotNull Integer amount, @NotNull Integer completionAmount, @NotNull String content) {
        String msg;
        DemandTypeEnum demandTypeEnum = DemandTypeEnum.getEnumThrow(demandType);
        switch (demandTypeEnum) {
            case KILL: {
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + MythicMobUtil.getInstance().getMythicMobName(content);
                break;
            }
            case KILL_PLAYER: 
            case KILL_MP: 
            case CHAT: 
            case COMMAND: {
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + content;
                break;
            }
            case KILL_NORMAL: 
            case BREED: 
            case TAME: {
                String name = ConfigUtil.MONSTER_CONFIG.getString(content, TranslationUtil.getEntityTranslation(content));
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + name;
                break;
            }
            case BLOCK_BREAK: {
                ItemStack itemStack = ItemStackUtil.getItemStack(content);
                boolean isAgeAble = DemandReplaceUtil.isAgeAble(itemStack);
                String demand = isAgeAble ? BaseUtil.getMsgNotColor("demand.harvest") : DemandTypeEnum.getTypeName(demandTypeEnum.getType());
                String blockBreakDisplayName = BaseUtil.getDisplayName(itemStack);
                msg = demand + " " + completionAmount + "/" + amount + " " + blockBreakDisplayName;
                break;
            }
            case ENCHANTMENT: {
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + TaskEnchantmentEnum.getTypeName(content);
                break;
            }
            case SHEAR: {
                ItemStack shearItemStack = ItemStackUtil.getItemStack(content);
                String shearDisplayName = BaseUtil.getDisplayName(shearItemStack);
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + shearDisplayName;
                break;
            }
            case CRAFT_ITEM: {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(content);
                boolean isNetheriteGear = DemandReplaceUtil.isNetheriteGear(itemStack);
                String craftItemDemand = isNetheriteGear ? BaseUtil.getMsgNotColor("demand.smith") : DemandTypeEnum.getTypeName(demandTypeEnum.getType());
                String craftItemDisPlayName = BaseUtil.getDisplayName(itemStack);
                msg = craftItemDemand + " " + completionAmount + "/" + amount + " " + craftItemDisPlayName;
                break;
            }
            default: {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(content);
                String defaultDisplayName = BaseUtil.getDisplayName(itemStack);
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + defaultDisplayName;
            }
        }
        MessageUtil.sendActionbar(player, msg);
    }

    public static List<String> taskScheduleReplaceMap(@NotNull List<TaskPlayerDemand> taskPlayerDemands) {
        return TaskUtil.taskScheduleReplaceMap(taskPlayerDemands);
    }

    private static class SingletonHolder {
        private static final PlayerTaskApi INSTANCE = new PlayerTaskApi();

        private SingletonHolder() {
        }
    }
}

