/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.constants;

import com.handy.playertask.lib.BaseUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public enum DemandTypeEnum {
    ALL("all", 0),
    CRAFT_ITEM("craftItem", 1),
    BLOCK_BREAK("blockBreak", 2),
    FISH("Fish", 3),
    INTERACT("Interact", 4),
    KILL("kill", 5),
    CONSUME("consume", 6),
    KILL_NORMAL("killNormal", 7),
    SUBMIT("submit", 8),
    KILL_PLAYER("killPlayer", 9),
    ENCHANTMENT("enchantment", 10),
    SHEAR("shear", 11),
    BREED("breed", 12),
    TAME("tame", 13),
    CHAT("chat", 14),
    KILL_MP("killMp", 15),
    INTERACTION("interaction", 16),
    COMMAND("command", 17),
    CUSTOM("custom", 18);

    private final String type;
    private final Integer typeId;

    public static DemandTypeEnum getEnumThrow(String type) {
        for (DemandTypeEnum demandTypeEnum : DemandTypeEnum.values()) {
            if (!demandTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return demandTypeEnum;
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u4efb\u52a1\u76ee\u6807\u7c7b\u578b(error Demand Type)");
    }

    public static DemandTypeEnum getNextEnum(String name) {
        DemandTypeEnum anEnum = DemandTypeEnum.getEnumThrow(name);
        int num = anEnum.getTypeId() + 1;
        if (num > CUSTOM.getTypeId()) {
            num = ALL.getTypeId();
        }
        for (DemandTypeEnum demandTypeEnum : DemandTypeEnum.values()) {
            if (demandTypeEnum.getTypeId() != num) continue;
            return demandTypeEnum;
        }
        return ALL;
    }

    public static List<String> getEnumNotAll() {
        ArrayList<String> enumList = new ArrayList<String>();
        for (DemandTypeEnum demandTypeEnum : DemandTypeEnum.values()) {
            if (ALL.equals((Object)demandTypeEnum)) continue;
            enumList.add(demandTypeEnum.getType());
        }
        return enumList;
    }

    public static String getTypeName(String type) {
        for (DemandTypeEnum demandTypeEnum : DemandTypeEnum.values()) {
            if (!demandTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return BaseUtil.getMsgNotColor("demand." + type);
        }
        return null;
    }

    public static String getType(Integer typeId) {
        for (DemandTypeEnum demandTypeEnum : DemandTypeEnum.values()) {
            if (!demandTypeEnum.getTypeId().equals(typeId)) continue;
            return demandTypeEnum.getType();
        }
        return null;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getTypeId() {
        return this.typeId;
    }

    @Generated
    private DemandTypeEnum(String type, Integer typeId) {
        this.type = type;
        this.typeId = typeId;
    }
}

