/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.constants;

import com.handy.playertask.lib.BaseConstants;
import com.handy.playertask.lib.BaseUtil;
import com.handy.playertask.lib.HandyPermissionUtil;
import com.handy.playertask.lib.LotteryUtil;
import com.handy.playertask.lib.MessageUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.entity.Player;

public enum RarityEnum {
    ALL("all", -1, ""),
    NORMAL("normal", 0, "&f"),
    ADVANCED("advanced", 1, "&9"),
    RARE("rare", 2, "&5"),
    RARER("rarer", 3, "&d"),
    EPIC("epic", 4, "&e"),
    MYTHICAL("mythical", 5, "&e&l");

    private final String type;
    private final Integer index;
    private final String color;

    public static Map<String, Integer> getTypeMap(Player player, int num) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        ArrayList<Double> probabilityList = new ArrayList<Double>();
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (ALL.equals((Object)rarityEnum)) continue;
            Double permissionNumber = HandyPermissionUtil.getDoubleNumber(player, BaseConstants.CONFIG, "rarity." + rarityEnum.getType());
            probabilityList.add(permissionNumber);
        }
        LotteryUtil lotteryUtil = new LotteryUtil(probabilityList);
        for (int i2 = 0; i2 < num; ++i2) {
            String type = RarityEnum.getByIndex(lotteryUtil.randomIndex()).getType();
            map.merge(type, 1, Integer::sum);
        }
        for (String rarity : map.keySet()) {
            MessageUtil.sendConsoleDebugMessage("\u4eca\u65e5\u4efb\u52a1\u62bd\u53d6,\u7c7b\u578b:" + BaseUtil.getMsgNotColor("rarity." + rarity) + ",\u6570\u91cf:" + map.get(rarity));
        }
        return map;
    }

    public static RarityEnum getByIndex(Integer index) {
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (!rarityEnum.getIndex().equals(index)) continue;
            return rarityEnum;
        }
        return NORMAL;
    }

    public static List<String> getTabEnum() {
        ArrayList<String> enumList = new ArrayList<String>();
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (ALL.equals((Object)rarityEnum)) continue;
            enumList.add(rarityEnum.getType());
        }
        return enumList;
    }

    public static RarityEnum getEnum(String type) {
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (!rarityEnum.getType().equalsIgnoreCase(type)) continue;
            return rarityEnum;
        }
        return NORMAL;
    }

    public static RarityEnum getNextEnum(String name) {
        RarityEnum anEnum = RarityEnum.getEnum(name);
        int num = anEnum.getIndex() + 1;
        if (num > 5) {
            num = -1;
        }
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (rarityEnum.getIndex() != num) continue;
            return rarityEnum;
        }
        return NORMAL;
    }

    public static String getEnumName(String type) {
        return BaseUtil.getMsgNotColor("rarity." + type);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    private RarityEnum(String type, Integer index, String color) {
        this.type = type;
        this.index = index;
        this.color = color;
    }
}

