/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.constants;

import com.handy.playertask.hook.PlayerCurrencyUtil;
import com.handy.playertask.lib.BaseUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public enum RewardTypeEnum {
    ALL("all", 0),
    VAULT("vault", 1),
    PLAYER_POINTS("playerPoints", 2),
    COIN("coin", 3),
    ITEM_STACK("itemStack", 4),
    COMMAND("command", 5),
    PLAYER_CURRENCY("player_currency", -1);

    private String type;
    private final Integer typeId;

    public static RewardTypeEnum getEnumThrow(String type) {
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (!rewardTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return rewardTypeEnum;
        }
        if (type.contains("ply_")) {
            RewardTypeEnum playerCurrency = PLAYER_CURRENCY;
            playerCurrency.type = type;
            return playerCurrency;
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u5956\u52b1\u7c7b\u578b(error Reward Type):" + type);
    }

    public static List<String> getEnumNotAll() {
        ArrayList<String> enumList = new ArrayList<String>();
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (ALL.equals((Object)rewardTypeEnum) || PLAYER_CURRENCY.equals((Object)rewardTypeEnum)) continue;
            enumList.add(rewardTypeEnum.getType());
        }
        enumList.addAll(PlayerCurrencyUtil.findAllType());
        return enumList;
    }

    public static String getTypeName(String type) {
        if (type.contains("ply_")) {
            return PlayerCurrencyUtil.getDesc(type);
        }
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (!rewardTypeEnum.getType().equals(type)) continue;
            return BaseUtil.getMsgNotColor("reward." + type);
        }
        return null;
    }

    public static RewardTypeEnum getNextEnum(String name) {
        RewardTypeEnum anEnum = RewardTypeEnum.getEnumThrow(name);
        int num = anEnum.getTypeId() + 1;
        if (num > RewardTypeEnum.COMMAND.typeId) {
            num = 0;
        }
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (rewardTypeEnum.getTypeId() != num) continue;
            return rewardTypeEnum;
        }
        return ALL;
    }

    @Generated
    public Integer getTypeId() {
        return this.typeId;
    }

    @Generated
    private RewardTypeEnum(String type, Integer typeId) {
        this.type = type;
        this.typeId = typeId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }
}

