/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.constants;

import com.handy.playertask.lib.BaseUtil;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public enum TaskTypeEnum {
    ALL("all", 0),
    EVERYDAY("everyday", 1),
    NPC("npc", 2),
    REEL("reel", 3);

    private final String type;
    private final Integer typeId;

    public static TaskTypeEnum getEnum(String type) {
        for (TaskTypeEnum taskTypeEnum : TaskTypeEnum.values()) {
            if (!taskTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return taskTypeEnum;
        }
        return EVERYDAY;
    }

    public static List<String> getTabEnum() {
        return Arrays.asList(TaskTypeEnum.EVERYDAY.type, TaskTypeEnum.NPC.type);
    }

    public static String getTypeName(String type) {
        for (TaskTypeEnum taskTypeEnum : TaskTypeEnum.values()) {
            if (!taskTypeEnum.getType().equals(type)) continue;
            return BaseUtil.getMsgNotColor("taskType." + type);
        }
        return type;
    }

    public static TaskTypeEnum getNextEnum(String name) {
        TaskTypeEnum anEnum = TaskTypeEnum.getEnum(name);
        int num = anEnum.getTypeId() + 1;
        if (num > 2) {
            num = 0;
        }
        for (TaskTypeEnum taskTypeEnum : TaskTypeEnum.values()) {
            if (taskTypeEnum.getTypeId() != num) continue;
            return taskTypeEnum;
        }
        return EVERYDAY;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getTypeId() {
        return this.typeId;
    }

    @Generated
    private TaskTypeEnum(String type, Integer typeId) {
        this.type = type;
        this.typeId = typeId;
    }
}

