/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.hook;

import com.handy.playertask.PlayerTask;
import com.handy.playertask.lib.BaseConstants;
import com.handy.playertask.lib.DateUtil;
import com.handy.playertask.service.TaskCoinService;
import com.handy.playertask.service.TaskPlayerService;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderUtil
extends PlaceholderExpansion {
    private final PlayerTask plugin;

    public PlaceholderUtil(PlayerTask plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "playerTask";
    }

    public String onRequest(OfflinePlayer player, @NotNull String placeholder) {
        switch (placeholder) {
            case "num": {
                return BaseConstants.CONFIG.getString("todayTaskNum", "10");
            }
            case "complete_num": {
                Integer completeCount = TaskPlayerService.getInstance().findCount(player.getUniqueId(), DateUtil.getToday(), true);
                return completeCount != null ? completeCount.toString() : "0";
            }
            case "coin": {
                return TaskCoinService.getInstance().findCoinByPlayer(player.getUniqueId()).toString();
            }
        }
        return null;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

