/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.hook;

import cn.handyplus.currency.api.PlayerCurrencyApi;
import com.handy.playertask.PlayerTask;
import com.handy.playertask.lib.BaseUtil;
import com.handy.playertask.lib.HookPluginEnum;
import com.handy.playertask.lib.MessageUtil;
import com.handy.playertask.lib.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class PlayerCurrencyUtil {
    public static boolean take(Player player, String type, long price, String operatorReason) {
        if (!PlayerTask.USE_PLY) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor(HookPluginEnum.PLAYER_CURRENCY.getFailMsg()));
            return false;
        }
        return PlayerCurrencyApi.take((UUID)player.getUniqueId(), (String)PlayerCurrencyUtil.replacePrefix(type), (Long)price, (String)PlayerTask.INSTANCE.getName(), (String)operatorReason);
    }

    public static boolean give(Player player, String type, long price, String operatorReason) {
        if (price == 0L) {
            return false;
        }
        if (!PlayerTask.USE_PLY) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor(HookPluginEnum.PLAYER_CURRENCY.getFailMsg()));
            return false;
        }
        return PlayerCurrencyApi.give((UUID)player.getUniqueId(), (String)PlayerCurrencyUtil.replacePrefix(type), (Long)price, (String)PlayerTask.INSTANCE.getName(), (String)operatorReason);
    }

    public static Long look(Player player, String type) {
        if (!PlayerTask.USE_PLY || player == null || StrUtil.isEmpty(type)) {
            return 0L;
        }
        return PlayerCurrencyApi.look((UUID)player.getUniqueId(), (String)PlayerCurrencyUtil.replacePrefix(type));
    }

    public static String getDesc(String type) {
        if (!PlayerTask.USE_PLY || StrUtil.isEmpty(type)) {
            return type;
        }
        return PlayerCurrencyApi.getDesc((String)PlayerCurrencyUtil.replacePrefix(type));
    }

    public static List<String> findAllType() {
        if (!PlayerTask.USE_PLY) {
            return new ArrayList<String>();
        }
        return PlayerCurrencyApi.findAllType().stream().map(s2 -> "ply_" + s2).collect(Collectors.toList());
    }

    private static String replacePrefix(String type) {
        return type.replace("ply_", "");
    }
}

