/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib;

import com.handy.playertask.lib.AssertUtil;
import com.handy.playertask.lib.BaseConstants;
import com.handy.playertask.lib.CollUtil;
import com.handy.playertask.lib.FormulaUtil;
import com.handy.playertask.lib.HandyHttpUtil;
import com.handy.playertask.lib.HookPluginEnum;
import com.handy.playertask.lib.ItemStackUtil;
import com.handy.playertask.lib.JsonUtil;
import com.handy.playertask.lib.LegacyUtil;
import com.handy.playertask.lib.MessageUtil;
import com.handy.playertask.lib.NetUtil;
import com.handy.playertask.lib.PatternUtil;
import com.handy.playertask.lib.RgbTextUtil;
import com.handy.playertask.lib.StrUtil;
import com.handy.playertask.lib.TranslationUtil;
import com.handy.playertask.lib.VersionCheckEnum;
import com.handy.playertask.service.TaskDemandService;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BaseUtil {
    public static Boolean isNotPlayer(@NotNull CommandSender sender) {
        return !BaseUtil.isPlayer(sender).booleanValue();
    }

    public static Optional<Plugin> hookToPlugin(@NotNull HookPluginEnum hookPluginEnum) {
        Optional<Plugin> optional = BaseUtil.hook(hookPluginEnum.getName());
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? hookPluginEnum.getSuccessMsg() : hookPluginEnum.getFailMsg()));
        return optional;
    }

    public static Player getOnlinePlayer(@NotNull CommandSender sender, @NotNull String playerName, @NotNull String msg) {
        if (StrUtil.isEmpty(playerName)) {
            return AssertUtil.notPlayer(sender, msg);
        }
        return BaseUtil.getOnlinePlayer(playerName).orElseThrow(() -> new RuntimeException(msg));
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg());
    }

    public static String getLangMsg(@NotNull String langMsg, @NotNull String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, true);
    }

    public static void readJsonFileToItemJsonCacheMap(@NotNull File file) {
        Optional<String> optional = BaseUtil.readJsonFile(file);
        if (optional.isPresent()) {
            if (optional.get().length() > 1) {
                try {
                    BaseConstants.ITEM_JSON_CACHE_MAP = JsonUtil.toMap(optional.get());
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static OfflinePlayer getOfflinePlayer(@NotNull UUID playerUuid) {
        return Bukkit.getOfflinePlayer((UUID)playerUuid);
    }

    @NotNull
    public static String getDisplayName(ItemStack a2) {
        if (a2 == null) {
            a2 = new ItemStack(Material.AIR);
        }
        ItemStack itemStack = a2;
        Object object = ItemStackUtil.getItemMeta(itemStack);
        String string = itemStack.getType().name();
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId() && object.hasItemName()) {
            return object.getItemName();
        }
        if (object.hasDisplayName()) {
            return object.getDisplayName();
        }
        object = TranslationUtil.getMaterialTranslation(string);
        if (StrUtil.isNotEmpty((CharSequence)object)) {
            return object;
        }
        if (!BaseConstants.ITEM_JSON_CACHE_MAP.isEmpty() && (object = BaseConstants.ITEM_JSON_CACHE_MAP.get(string)) != null) {
            return object;
        }
        if (!BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.isEmpty()) {
            if (a2.getDurability() > 0 && StrUtil.isNotEmpty((CharSequence)(object = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(new StringBuilder().insert(0, string).append(FormulaUtil.g("\u001a")).append(a2.getDurability()).toString())))) {
                return object;
            }
            object = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(string);
            if (object != null) {
                return object;
            }
        }
        return string;
    }

    public static OfflinePlayer getOfflinePlayer(@NotNull String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName);
    }

    public static String getLangMsg(@NotNull String langMsg, @NotNull String defaultMsg, boolean isColor) {
        if (StrUtil.isEmpty(langMsg)) {
            return defaultMsg;
        }
        FileConfiguration fileConfiguration = BaseConstants.LANG_CONFIG;
        if (fileConfiguration == null) {
            return defaultMsg;
        }
        defaultMsg = fileConfiguration.getString(langMsg, defaultMsg);
        if (isColor) {
            return BaseUtil.replaceChatColor(defaultMsg);
        }
        return defaultMsg;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> readJsonFile(@NotNull File fileName) {
        StringBuilder stringBuilder;
        InputStreamReader inputStreamReader;
        FileReader fileReader;
        try {
            fileReader = new FileReader(fileName);
            inputStreamReader = new InputStreamReader(Files.newInputStream(fileName.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader2 = inputStreamReader;
            while (true) {
                int n = ((Reader)inputStreamReader2).read();
                if (n != -1) {
                    inputStreamReader2 = inputStreamReader;
                    stringBuilder.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, FormulaUtil.g("7\u0002$\u0003\u000f\u0014*\t\u0003\u000e)\u0002e\u53b6\u755a\u5f65\u5e7d"), exception);
            return Optional.empty();
        }
        {
            fileReader.close();
            ((Reader)inputStreamReader).close();
            return Optional.of(stringBuilder.toString());
        }
    }

    public static void sendTip(@NotNull CommandSender sender) {
        String string = BaseConstants.CONFIG.getString("signType", "mac");
        String string2 = string = "mac".equalsIgnoreCase(string) ? NetUtil.getLocalMacAddress() : HandyHttpUtil.getIp();
        if (BaseUtil.isPlayer(sender).booleanValue() && BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_15.getVersionId()) {
            RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init(string);
            String string3 = BaseUtil.getMsgNotColor(FormulaUtil.g("\u0004*\u0017<"), TaskDemandService.pPPPPp("$H\"\u001a\"\u001c:a$[\u70bb\u51c1\u590f\u520c$\u0002_"));
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(string3).addClickCopyToClipboard(string).build());
            rgbTextUtil.send(sender);
            return;
        }
        MessageUtil.sendMessage(sender, string);
    }

    public static int getFirstPluginVersion(@NotNull Plugin plugin) {
        return Integer.parseInt(plugin.getDescription().getVersion().split(TaskDemandService.pPPPPp("f,"))[0]);
    }

    public static boolean hook(@NotNull String pluginName, @NotNull String succeedMsgNode, @NotNull String failureMsgNode, @NotNull Integer version) {
        Optional<Object> optional = BaseUtil.hook(pluginName);
        if (optional.isPresent() && BaseUtil.getFirstPluginVersion(optional.get()) < version) {
            optional = Optional.empty();
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? succeedMsgNode : failureMsgNode));
        return optional.isPresent();
    }

    public static Optional<EntityType> getEntityType(@NotNull String key) {
        try {
            return Optional.of(EntityType.valueOf((String)key.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public static UUID getUuid(@NotNull String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
    }

    public static Boolean isPlayer(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    public static Optional<Plugin> hook(@NotNull String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    public static String getMsgNotColor(@NotNull String langMsg, @NotNull Map<String, String> replaceMap) {
        String string = BaseUtil.getMsgNotColor(langMsg, "");
        if (replaceMap != null) {
            Iterator<String> iterator;
            Iterator<String> iterator2 = iterator = replaceMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2;
                String string3 = string2 = iterator.next();
                string = string.replace(string3, replaceMap.get(string3));
                iterator2 = iterator;
            }
        }
        return string;
    }

    public static String stripColor(@NotNull String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        return ChatColor.stripColor((String)BaseUtil.replaceChatColor(str));
    }

    public static boolean hook(@NotNull String pluginName, @NotNull String succeedMsgNode, @NotNull String failureMsgNode) {
        Optional<Plugin> optional = BaseUtil.hook(pluginName);
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? succeedMsgNode : failureMsgNode));
        return optional.isPresent();
    }

    public static int getTwoPluginVersion(@NotNull Plugin plugin) {
        return Integer.parseInt(plugin.getDescription().getVersion().split(FormulaUtil.g(";k"))[1]);
    }

    private /* synthetic */ BaseUtil() {
        BaseUtil a2;
    }

    public static Optional<Player> getOnlinePlayer(@NotNull UUID playerUuid) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static Integer convertVersion(@NotNull String version) {
        int n;
        String[] stringArray = version.replaceAll(TaskDemandService.pPPPPp("a\\ff\u0014_"), "");
        if (!stringArray.contains(".")) {
            return Integer.parseInt((String)stringArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringArray = stringArray.split(FormulaUtil.g(";k"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            String string = stringArray[n];
            if (string.length() == 1) {
                stringBuilder.append(TaskDemandService.pPPPPp("2"));
            }
            stringBuilder.append(string);
            n3 = ++n;
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    public static List<String> replaceChatColor(@NotNull List<String> strList) {
        Iterator<String> iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (CollUtil.isEmpty(strList)) {
            return arrayList;
        }
        Iterator<String> iterator2 = iterator = strList.iterator();
        while (iterator2.hasNext()) {
            String string = iterator.next();
            iterator2 = iterator;
            arrayList.add(BaseUtil.replaceChatColor(string));
        }
        return arrayList;
    }

    public static void readJsonFileToJsonCacheMap(@NotNull File file) {
        try {
            Optional<String> optional = BaseUtil.readJsonFile(file);
            optional.ifPresent(a2 -> {
                BaseConstants.JSON_CACHE_MAP = JsonUtil.toMap(a2);
            });
            return;
        }
        catch (Throwable throwable) {
            MessageUtil.sendConsoleDebugMessage(TaskDemandService.pPPPPp("\u8bf9\u53eckNgW,PqUl\u5f38\u5e3a"));
            return;
        }
    }

    public static String getMsgNotColor(@NotNull String langMsg) {
        return BaseUtil.getMsgNotColor(langMsg, "");
    }

    public static Optional<Sound> getSound(@NotNull String sound) {
        try {
            return Optional.of(LegacyUtil.getSound(sound));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, FormulaUtil.g("\"\u000214*\u0012+\u0003e\u53b6\u755a\u5f65\u5e7d"), exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<Biome> getBiome(@NotNull String biome) {
        try {
            return Optional.of(LegacyUtil.getBiome(biome));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, TaskDemandService.pPPPPp("e_vxkUo_\"\u53eb\u751d\u5f38\u5e3a"), exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<Player> getOnlinePlayer(@NotNull String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static String replaceChatColor(@NotNull String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        String string = str.replace(FormulaUtil.g("c"), TaskDemandService.pPPPPp("\u00a5"));
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return string;
        }
        return BaseUtil.g(string);
    }

    public static void isPrimaryThread(@NotNull String name) {
        if (!BaseConstants.DEBUG) {
            return;
        }
        MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, name).append(FormulaUtil.g("]e")).append(Bukkit.isPrimaryThread()).toString());
    }

    private static /* synthetic */ String g(@NotNull String str) {
        Matcher matcher = PatternUtil.RPG_PATTERN.matcher(str);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher2 = matcher;
        while (matcher2.find()) {
            String string = matcher.group();
            if (string.length() == 5) {
                string = new StringBuilder().insert(0, string.substring(0, 2)).append(BaseUtil.iiIiii(string.substring(2))).toString();
            }
            Matcher matcher3 = matcher;
            matcher2 = matcher3;
            matcher3.appendReplacement(stringBuffer, ChatColor.of((String)string.substring(1)).toString());
        }
        matcher.appendTail(stringBuffer);
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)stringBuffer.toString());
    }

    public static String getMsgNotColor(@NotNull String langMsg, @NotNull String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, false);
    }

    public static String getLangMsg(@NotNull String langMsg) {
        return BaseUtil.getLangMsg(langMsg, "");
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum, @NotNull Integer version) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg(), version);
    }

    private static /* synthetic */ String iiIiii(@NotNull String str) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = str.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            stringBuilder.append(c2);
            stringBuilder.append(c2);
            n3 = ++n;
        }
        return stringBuilder.toString();
    }
}

