/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib;

import com.handy.playertask.lib.BaseConstants;
import com.handy.playertask.lib.CollUtil;
import com.handy.playertask.lib.HandyPermissionUtil;
import com.handy.playertask.lib.MessageUtil;
import com.handy.playertask.lib.VersionCheckEnum;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public final class LegacyUtil {
    private static Class<?> l;
    private static Class<?> h;
    private static Class<?> iiIIII;

    public static List<String> getEnchantmentList() {
        return Arrays.stream(Enchantment.values()).map(Enchantment::getName).collect(Collectors.toList());
    }

    private /* synthetic */ LegacyUtil() {
        LegacyUtil a2;
    }

    public static AttributeModifier getAttributeModifier(@NotNull String name, double amount, @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlot a2) {
        UUID uUID = UUID.randomUUID();
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21.getVersionId()) {
            return new AttributeModifier(uUID, name, amount, operation, a2);
        }
        return new AttributeModifier(NamespacedKey.fromString((String)uUID.toString()), amount, operation, a2.getGroup());
    }

    public static String getEntityTypeName(@NotNull EntityType entityType) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return entityType.getKey().getKey();
        }
        return entityType.getName();
    }

    public static Sound getSound(@NotNull String sound) throws Exception {
        if (l.isEnum()) {
            Enum enum_ = Enum.valueOf(l.asSubclass(Enum.class), sound.toUpperCase());
            return (Sound)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = l.getMethod(CollUtil.pPPPPp("(J2^;d8"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = sound.toUpperCase();
        return (Sound)method.invoke(null, objectArray);
    }

    public static List<String> getEntityTypeAliveList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId();
        EntityType[] entityTypeArray = EntityType.values();
        int n2 = entityTypeArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            EntityType entityType = entityTypeArray[n];
            if (entityType.isAlive() && entityType.isSpawnable()) {
                if (bl) {
                    arrayList.add(entityType.getKey().getKey());
                } else {
                    arrayList.add(entityType.getName());
                }
            }
            n3 = ++n;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initClasses() {
        try {
            l = Class.forName(CollUtil.pPPPPp("D,LpI+@5B*\u0005\rD+E:"));
            h = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_9.getVersionId() ? Class.forName(HandyPermissionUtil.pPPPPp("\"9*e/>& $?c*9??\"/>9.c\n9??\"/>9.")) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(HandyPermissionUtil.pPPPPp("\u65ab\u6c98\u6235\u527d\u7c30"), classNotFoundException);
        }
        {
            iiIIII = Class.forName(CollUtil.pPPPPp("D,LpI+@5B*\u0005<G1H5\u0005\u001cB1F;"));
            return;
        }
    }

    public static PotionEffectType getPotionEffectTypeByName(@NotNull String name) {
        return PotionEffectType.getByName((String)name);
    }

    public static String getEnchantmentName(@NotNull Enchantment enchantment) {
        return enchantment.getName();
    }

    public static Attribute getAttribute(@NotNull String name) {
        if (h == null) {
            return null;
        }
        if (h.isEnum()) {
            try {
                Enum enum_ = Enum.valueOf(h.asSubclass(Enum.class), name);
                return (Attribute)enum_;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(new StringBuilder().insert(0, CollUtil.pPPPPp("\u6cff\u6722\u6220\u521b\u76da\u5c75\u6079\u0011~")).append(name).toString(), illegalArgumentException);
            }
        }
        try {
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            Method method = h.getMethod(HandyPermissionUtil.pPPPPp("=,'8.\u0002-"), classArray);
            Object[] objectArray = new Object[1];
            objectArray[0] = name;
            return (Attribute)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder().insert(0, CollUtil.pPPPPp("\u6c8a\u6757\u6255\u526e\u5c75\u6079\u0011~")).append(name).toString(), exception);
        }
    }

    public static String getEnchantmentKey(@NotNull Enchantment enchantment) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            return enchantment.getKey().getKey();
        }
        return null;
    }

    public static List<String> getPotionEffectTypeList() {
        return Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName).collect(Collectors.toList());
    }

    public static List<String> getEntityTypeList() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return Arrays.stream(EntityType.values()).filter(a2 -> {
                if (a2 != EntityType.UNKNOWN) {
                    return true;
                }
                return false;
            }).map(a2 -> a2.getKey().getKey()).collect(Collectors.toList());
        }
        return Arrays.stream(EntityType.values()).map(EntityType::getName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void setGameRuleValue(@NotNull World world, @NotNull String ruleName, @NotNull Object value) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            GameRule gameRule = GameRule.getByName((String)ruleName);
            if (gameRule == null) {
                MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, HandyPermissionUtil.pPPPPp("\u4e5b\u7507\u8989\u5252wk")).append(ruleName).append(CollUtil.pPPPPp("~\u4e26\u5b06\u5703p")).toString());
                return;
            }
            if (value instanceof Boolean) {
                world.setGameRule(gameRule, (Object)((Boolean)value));
                return;
            }
            if (value instanceof Integer) {
                world.setGameRule(gameRule, (Object)((Integer)value));
                return;
            }
        }
        world.setGameRuleValue(ruleName, String.valueOf(value));
    }

    public static Biome getBiome(@NotNull String name) throws Exception {
        if (iiIIII.isEnum()) {
            Enum enum_ = Enum.valueOf(iiIIII.asSubclass(Enum.class), name);
            return (Biome)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = iiIIII.getMethod(HandyPermissionUtil.pPPPPp("=,'8.\u0002-"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = name;
        return (Biome)method.invoke(null, objectArray);
    }

    public static EntityType getEntityTypeByName(@NotNull String name) {
        return EntityType.fromName((String)name);
    }

    public static Enchantment getEnchantmentByName(@NotNull String name) {
        return Enchantment.getByName((String)name);
    }

    public static double getMaxHealth(@NotNull Player player) {
        return player.getMaxHealth();
    }

    public static void setMaxHealth(@NotNull Player player, double maxHealth) {
        player.setMaxHealth(maxHealth);
    }

    public static Particle getDripLava() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DRIPPING_LAVA;
        }
        return Particle.valueOf((String)CollUtil.pPPPPp("\u001ay\u0017{\u0001g\u001f}\u001f"));
    }

    public static PotionEffectType getIncreaseDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return PotionEffectType.getByName((String)CollUtil.pPPPPp("X*Y;E9_6"));
        }
        return PotionEffectType.getByName((String)HandyPermissionUtil.pPPPPp("\"#(?.,8(\u0014)* **."));
    }

    public static Particle getFirework() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.FIREWORK;
        }
        return Particle.valueOf((String)HandyPermissionUtil.pPPPPp("\r\u0004\u0019\b\u001c\u0002\u0019\u0006\u0018\u0012\u0018\u001d\n\u001f\u0000"));
    }

    public static Enchantment getDurability() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.UNBREAKING;
        }
        return LegacyUtil.getEnchantmentByName(HandyPermissionUtil.pPPPPp("\t\u001e\u001f\n\u000f\u0002\u0001\u0002\u0019\u0012"));
    }

    public static Enchantment getArrowDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.POWER;
        }
        return LegacyUtil.getEnchantmentByName(CollUtil.pPPPPp("j\fy\u0011|\u0001o\u001ff\u001fl\u001b"));
    }

    public static Particle getRedStone() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DUST;
        }
        return Particle.valueOf((String)HandyPermissionUtil.pPPPPp("\u001f\u000e\t\u0018\u0019\u0004\u0003\u000e"));
    }
}

