/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib;

import com.handy.playertask.lib.BaseConstants;
import com.handy.playertask.lib.CollUtil;
import com.handy.playertask.lib.LegacyUtil;
import com.handy.playertask.lib.MapUtil;
import com.handy.playertask.lib.StrUtil;
import com.handy.playertask.util.BackUpUtil;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class TranslationUtil {
    @NotNull
    public static String getColorTranslation(@NotNull String color) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return color;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, BackUpUtil.pPPPPp("(:':9{&<%0('*3?{")).append(color.toLowerCase()).toString(), color);
    }

    @Nullable
    public static String getMaterialTranslation(@NotNull String materialName) {
        String string = TranslationUtil.getItemTranslation(materialName);
        if (StrUtil.isNotEmpty(string)) {
            return string;
        }
        return TranslationUtil.getBlockTranslation(materialName);
    }

    public TranslationUtil() {
        TranslationUtil a2;
    }

    @Nullable
    public static String getBlockTranslation(@NotNull String block) {
        if (MapUtil.isEmpty(BaseConstants.JSON_CACHE_MAP)) {
            return null;
        }
        return BaseConstants.JSON_CACHE_MAP.get(new StringBuilder().insert(0, BackUpUtil.pPPPPp(")9$6 {&<%0('*3?{")).append(block.toLowerCase()).toString());
    }

    @NotNull
    public static String getEnchantmentLevelTranslation(@NotNull String enchantmentLevel) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return enchantmentLevel;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, CollUtil.pPPPPp("N0H6J0_3N0_pG;];Gp")).append(enchantmentLevel).toString(), enchantmentLevel);
    }

    @Nullable
    public static String getItemTranslation(@NotNull String item) {
        if (MapUtil.isEmpty(BaseConstants.JSON_CACHE_MAP)) {
            return null;
        }
        return BaseConstants.JSON_CACHE_MAP.get(new StringBuilder().insert(0, CollUtil.pPPPPp("7_;FpF7E;H,J8_p")).append(item.toLowerCase()).toString());
    }

    @NotNull
    public static String getEnchantmentTranslation(@NotNull String enchantment) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return enchantment;
        }
        String string = LegacyUtil.getEnchantmentKey(LegacyUtil.getEnchantmentByName(enchantment));
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, BackUpUtil.pPPPPp(".;(=*;?8.;?{&<%0('*3?{")).append(string).toString(), enchantment);
    }

    @NotNull
    public static String getEffectTranslation(@NotNull String effect) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return effect;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, BackUpUtil.pPPPPp("0-3.6?{&<%0('*3?{")).append(effect.toLowerCase()).toString(), effect);
    }

    @NotNull
    public static String getEntityTranslation(@NotNull String entity) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return entity;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, CollUtil.pPPPPp(";E*B*RpF7E;H,J8_p")).append(entity.toLowerCase()).toString(), entity);
    }
}

