/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib.mm;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MythicMobHighUtil {
    private static final MythicMobHighUtil INSTANCE = new MythicMobHighUtil();

    private MythicMobHighUtil() {
    }

    protected static MythicMobHighUtil getInstance() {
        return INSTANCE;
    }

    protected Map<String, String> getMythicMobMap(Integer pageNum, Integer pageSize) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List<MythicMob> mythicMobs = this.getMythicMobs(pageNum, pageSize);
        if (mythicMobs != null && !mythicMobs.isEmpty()) {
            for (MythicMob mythicMob : mythicMobs) {
                String displayName = mythicMob.getDisplayName() != null ? mythicMob.getDisplayName().get() : mythicMob.getInternalName();
                map.put(displayName, mythicMob.getInternalName());
            }
        }
        return map;
    }

    protected List<MythicMob> getMythicMobs(Integer pageNum, Integer pageSize) {
        Collection mythicMobs = MythicBukkit.inst().getMobManager().getMobTypes();
        Stream limit = mythicMobs.stream().skip((long)pageNum.intValue() * (long)pageSize.intValue()).limit(pageSize.intValue());
        return limit.collect(Collectors.toList());
    }

    protected List<String> getMythicMobList() {
        Collection mythicMobs = MythicBukkit.inst().getMobManager().getMobTypes();
        return mythicMobs.stream().map(MythicMob::getInternalName).collect(Collectors.toList());
    }

    protected String getMythicMobName(String internalName) {
        Optional mythicMobOptional = MythicBukkit.inst().getMobManager().getMythicMob(internalName);
        if (mythicMobOptional.isPresent()) {
            MythicMob mythicMob = (MythicMob)mythicMobOptional.get();
            PlaceholderString placeholderString = mythicMob.getDisplayName();
            if (placeholderString == null) {
                return internalName;
            }
            return placeholderString.get();
        }
        return internalName;
    }

    protected Integer getMythicMobsCount() {
        Collection mythicMobs = MythicBukkit.inst().getMobManager().getMobTypes();
        return mythicMobs.size();
    }

    protected boolean mobIsExist(String internalName) {
        Optional mythicMobOptional = MythicBukkit.inst().getMobManager().getMythicMob(internalName);
        return mythicMobOptional.isPresent();
    }
}

