/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib.mm;

import com.handy.playertask.lib.mm.MythicMobHighUtil;
import com.handy.playertask.lib.mm.MythicMobLowUtil;
import com.handy.playertask.lib.mm.MythicMobMiddleUtil;
import com.handy.playertask.lib.mm.MythicMobVersionEnum;
import com.handy.playertask.lib.mm.VersionUtil;
import com.handy.playertask.lib.mm.listener.MythicMobDeathEventHideListener;
import com.handy.playertask.lib.mm.listener.MythicMobDeathEventLowListener;
import com.handy.playertask.lib.mm.listener.MythicMobDeathEventMiddleListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class MythicMobUtil {
    private static MythicMobVersionEnum MM_VERSION = null;
    private static final MythicMobUtil INSTANCE = new MythicMobUtil();

    private MythicMobUtil() {
    }

    public static MythicMobUtil getInstance() {
        return INSTANCE;
    }

    public static void init(Plugin plugin) {
        Plugin mythicMobs = Bukkit.getPluginManager().getPlugin("MythicMobs");
        if (mythicMobs != null && MM_VERSION == null) {
            int firstPluginVersion = VersionUtil.getFirstPluginVersion(mythicMobs);
            int twoPluginVersion = VersionUtil.getTwoPluginVersion(mythicMobs);
            if (firstPluginVersion >= 5) {
                MM_VERSION = MythicMobVersionEnum.HIDE;
                plugin.getServer().getPluginManager().registerEvents((Listener)new MythicMobDeathEventHideListener(), plugin);
            } else if (twoPluginVersion < 7) {
                MM_VERSION = MythicMobVersionEnum.LOW;
                plugin.getServer().getPluginManager().registerEvents((Listener)new MythicMobDeathEventLowListener(), plugin);
            } else {
                MM_VERSION = MythicMobVersionEnum.MIDDLE;
                plugin.getServer().getPluginManager().registerEvents((Listener)new MythicMobDeathEventMiddleListener(), plugin);
            }
        }
    }

    public Map<String, String> getMythicMobMap(Integer pageNum, Integer pageSize) {
        if (MM_VERSION == null) {
            return new HashMap<String, String>();
        }
        switch (MM_VERSION) {
            case LOW: {
                return MythicMobLowUtil.getInstance().getMythicMobMap(pageNum, pageSize);
            }
            case HIDE: {
                return MythicMobHighUtil.getInstance().getMythicMobMap(pageNum, pageSize);
            }
        }
        return MythicMobMiddleUtil.getInstance().getMythicMobMap(pageNum, pageSize);
    }

    public List<String> getMythicMobList() {
        if (MM_VERSION == null) {
            return new ArrayList<String>();
        }
        switch (MM_VERSION) {
            case LOW: {
                return MythicMobLowUtil.getInstance().getMythicMobList();
            }
            case HIDE: {
                return MythicMobHighUtil.getInstance().getMythicMobList();
            }
        }
        return MythicMobMiddleUtil.getInstance().getMythicMobList();
    }

    public String getMythicMobName(String internalName) {
        if (MM_VERSION == null) {
            return internalName;
        }
        switch (MM_VERSION) {
            case LOW: {
                return MythicMobLowUtil.getInstance().getMythicMobName(internalName);
            }
            case HIDE: {
                return MythicMobHighUtil.getInstance().getMythicMobName(internalName);
            }
        }
        return MythicMobMiddleUtil.getInstance().getMythicMobName(internalName);
    }

    public Integer getMythicMobsCount() {
        if (MM_VERSION == null) {
            return 0;
        }
        switch (MM_VERSION) {
            case LOW: {
                return MythicMobLowUtil.getInstance().getMythicMobsCount();
            }
            case HIDE: {
                return MythicMobHighUtil.getInstance().getMythicMobsCount();
            }
        }
        return MythicMobMiddleUtil.getInstance().getMythicMobsCount();
    }

    public boolean mobIsExist(String internalName) {
        if (MM_VERSION == null) {
            return false;
        }
        switch (MM_VERSION) {
            case LOW: {
                return MythicMobLowUtil.getInstance().mobIsExist(internalName);
            }
            case HIDE: {
                return MythicMobHighUtil.getInstance().mobIsExist(internalName);
            }
        }
        return MythicMobMiddleUtil.getInstance().mobIsExist(internalName);
    }
}

