/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.events;

import de.maxhenkel.peek.Peek;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class HudEvents {
    private static final class_310 MC = class_310.method_1551();
    private static final int PADDING = 4;
    private static final Quaternionf ENTITY_ANGLE = new Quaternionf().rotationXYZ(0.0f, (float)Math.PI, (float)Math.PI);
    private static final Map<class_1299<?>, class_1309> ENTITY_CACHE = new HashMap();

    public static void onRenderHud(class_332 graphics, int screenWidth, int screenHeight) {
        if (!Peek.CONFIG.showHud.get().booleanValue()) {
            return;
        }
        class_746 player = HudEvents.MC.field_1724;
        if (player == null) {
            return;
        }
        class_239 class_2392 = HudEvents.MC.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            HudEvents.renderBlockHud(player, graphics, screenWidth, screenHeight, blockHitResult);
        } else {
            class_2392 = HudEvents.MC.field_1765;
            if (class_2392 instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)class_2392;
                HudEvents.renderEntityHud(player, graphics, screenWidth, screenHeight, entityHitResult);
            }
        }
    }

    private static void renderBlockHud(class_746 player, class_332 graphics, int screenWidth, int screenHeight, class_3965 blockHitResult) {
        class_1937 level = player.method_73183();
        class_2680 blockState = level.method_8320(blockHitResult.method_17777());
        if (blockState.method_26215()) {
            return;
        }
        class_2248 block = blockState.method_26204();
        class_1799 item = block.method_9564().method_65171((class_4538)level, blockHitResult.method_17777(), true);
        class_2561 name = item.method_7964();
        class_327 font = HudEvents.MC.field_1772;
        int nameWidth = font.method_27525((class_5348)name);
        int itemSize = 16;
        int hudWidth = nameWidth + 12 + itemSize;
        int hudHeight = itemSize + 8;
        int hudLeft = screenWidth / 2 - hudWidth / 2;
        graphics.method_25294(hudLeft, 0, hudLeft + hudWidth, hudHeight, Peek.CONFIG.hudBackgroundColorValue);
        graphics.method_51427(item, hudLeft + 4, 4);
        int n = hudHeight / 2;
        Objects.requireNonNull(font);
        graphics.method_27535(font, name, hudLeft + itemSize + 8, n - 9 / 2, Peek.CONFIG.hudTextColorValue);
    }

    private static void renderEntityHud(class_746 player, class_332 graphics, int screenWidth, int screenHeight, class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_2561 name = entity.method_5477();
        class_327 font = HudEvents.MC.field_1772;
        int nameWidth = font.method_27525((class_5348)name);
        int maxEntityHeight = 16;
        int maxEntityWidth = 16;
        int hudWidth = nameWidth + 12 + maxEntityWidth;
        int hudHeight = maxEntityHeight + 8;
        int hudLeft = screenWidth / 2 - hudWidth / 2;
        graphics.method_25294(hudLeft, 0, hudLeft + hudWidth, hudHeight, Peek.CONFIG.hudBackgroundColorValue);
        int x1 = hudLeft + 4;
        int y1 = 4;
        int x2 = x1 + maxEntityWidth;
        int y2 = y1 + maxEntityHeight;
        HudEvents.renderEntity(graphics, x1, y1, x2, y2, maxEntityWidth, maxEntityHeight, HudEvents.getCachedEntity(livingEntity.method_5864()));
        int n = hudHeight / 2;
        Objects.requireNonNull(font);
        graphics.method_27535(font, name, hudLeft + maxEntityWidth + 8, n - 9 / 2, Peek.CONFIG.hudTextColorValue);
    }

    private static void renderEntity(class_332 graphics, int x1, int y1, int x2, int y2, float maxWidth, float maxHeight, class_1309 entity) {
        if (entity == null) {
            return;
        }
        float maxXScale = maxWidth / (entity.method_17681() * 1.5f);
        float maxYScale = maxHeight / (entity.method_17682() * 1.5f);
        int entityScale = (int)Math.min(maxXScale, maxYScale);
        Quaternionf rot = new Quaternionf();
        float r = (float)((double)System.currentTimeMillis() / 20.0 % 360.0);
        ENTITY_ANGLE.rotateY((float)Math.PI / 180 * r, rot);
        Vector3f offset = new Vector3f(0.0f, entity.method_17682() / 2.0f, 0.0f);
        HudEvents.renderEntityInInventory(graphics, x1, y1, x2, y2, entityScale, offset, rot, null, entity);
    }

    private static void renderEntityInInventory(class_332 guiGraphics, int x1, int y1, int x2, int y2, float scale, Vector3f translation, Quaternionf rotation, @Nullable Quaternionf overrideCameraAngle, class_1309 entity) {
        class_898 dispatcher = MC.method_1561();
        class_897 entityRenderer = dispatcher.method_3953((class_1297)entity);
        class_10017 state = entityRenderer.method_62425((class_1297)entity, 1.0f);
        state.field_61820 = 0xF000F0;
        state.field_61823.clear();
        state.field_61821 = 0;
        guiGraphics.method_70856(state, scale, translation, rotation, overrideCameraAngle, x1, y1, x2, y2);
    }

    private static class_1309 getCachedEntity(class_1299<?> entityType) {
        return ENTITY_CACHE.computeIfAbsent(entityType, type -> (class_1309)type.method_5883((class_1937)HudEvents.MC.field_1687, class_3730.field_16462));
    }
}

