// Created by and for modrinth.com/user/Hxndrik
#version 150

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform float GameTime;

in float vertexDistance;
in vec4 position;

out vec4 fragColor;

vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    if (vertexDistance <= fogStart) {
        return inColor;
    }

    float fogValue = vertexDistance < fogEnd ? smoothstep(fogStart, fogEnd, vertexDistance) : 1.0;
    return vec4(mix(inColor.rgb, fogColor.rgb, fogValue * fogColor.a), inColor.a);
}

void main() {
	vec4 color = ColorModulator;
	if (color.a < 1.0) { 
		color.a += sin((GameTime * 2000.0) + position.x + position.z);
    }
	
	fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}