/*
 * Decompiled with CFR 0.152.
 */
package net.pmkjun.quitefishing.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.pmkjun.quitefishing.util.QuiteFishingConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FishingHook.class})
public abstract class FishingMixin {
    private static final Logger LOGGER = LogManager.getLogger((String)"quitefishing");
    private static final Minecraft mc = Minecraft.getInstance();
    private boolean previouscaughtFish = false;
    @Shadow
    private boolean biting;

    @Shadow
    @Nullable
    public abstract Player getPlayerOwner();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void ontickMixin(CallbackInfo ci) {
        String bobberOwner;
        try {
            bobberOwner = this.getPlayerOwner().getName().getString();
        }
        catch (NullPointerException e) {
            return;
        }
        if (bobberOwner.equals(FishingMixin.mc.player.getName().getString()) && QuiteFishingConfig.isMuteotherfishingbobber && mc.isSameThread()) {
            if (!this.previouscaughtFish && this.biting) {
                LOGGER.info("fishBobber splash!");
                mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.FISHING_BOBBER_SPLASH, (float)1.0f, (float)QuiteFishingConfig.floatSlider));
                this.previouscaughtFish = true;
            }
            if (this.previouscaughtFish && !this.biting) {
                this.previouscaughtFish = false;
            }
        }
    }
}

