/*
 * Decompiled with CFR 0.152.
 */
package net.pmkjun.quitefishing.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TinyConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    private static Class<?> configClass;
    private static String translationPrefix;
    private static Path path;
    private static final Gson gson;

    public static void init(String modid, Path apath, Class<?> config) {
        translationPrefix = modid + ".tinyconfig.";
        configClass = config;
        path = apath;
        for (Field field : config.getFields()) {
            Entry e;
            try {
                e = field.getAnnotation(Entry.class);
            }
            catch (Exception ignored) {
                continue;
            }
            if (e == null) continue;
            Class<?> type = field.getType();
            EntryInfo info = new EntryInfo();
            info.width = e.width();
            info.field = field;
            if (type == Integer.TYPE) {
                TinyConfig.textField(info, Integer::parseInt, INTEGER_ONLY, e.min(), e.max(), true);
            } else if (type == Double.TYPE) {
                TinyConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class) {
                TinyConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.m_237113_((String)((Boolean)value != false ? "True" : "False"));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            } else {
                if (!type.isEnum()) continue;
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.m_237115_((String)(translationPrefix + "enum." + type.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            }
            entries.add(info);
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            try {
                info.dynamicTooltip = config.getMethod(e.dynamicTooltip(), new Class[0]);
                info.dynamicTooltip.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            info.comment = e.comment();
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            TinyConfig.write();
        }
        for (EntryInfo info : entries) {
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!(s = s.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            System.out.println(isNumber ^ s.isEmpty());
            System.out.println(!s.equals("-") && !s.equals("."));
            info.error = null;
            if (!(isNumber && s.isEmpty() || s.equals("-") || s.equals("."))) {
                value = (Number)f.apply((String)s);
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)t, Component.m_237113_((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))));
            }
            info.tempValue = s;
            t.m_94202_(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.f_93623_ = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                info.value = isNumber ? value : s;
            }
            return true;
        };
    }

    public static void write() {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson(configClass.newInstance()).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Screen getScreen(Screen parent) {
        return new TinyConfigScreen(parent);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).setPrettyPrinting().create();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public String comment() default "";

        public String dynamicTooltip() default "";

        public int width() default 75;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;
    }

    protected static class EntryInfo {
        Field field;
        Object widget;
        int width;
        String comment;
        Method dynamicTooltip;
        Map.Entry<EditBox, Component> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;

        protected EntryInfo() {
        }
    }

    private static class TinyConfigScreen
    extends Screen {
        private final Screen parent;

        protected TinyConfigScreen(Screen parent) {
            super((Component)Component.m_237113_((String)"QuiteFishing config"));
            this.parent = parent;
        }

        protected void m_7856_() {
            super.m_7856_();
            Button done = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
                for (EntryInfo info : entries) {
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                TinyConfig.write();
                this.f_96541_.m_91152_(this.parent);
            }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20).m_253136_());
            int y = 45;
            for (EntryInfo info : entries) {
                if (info.widget instanceof Map.Entry) {
                    widget = (Map.Entry)info.widget;
                    this.m_142416_((GuiEventListener)Button.m_253074_((Component)((Component)((Function)widget.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)widget.getKey())).m_252987_(this.f_96543_ - 85, y, info.width, 20).m_253136_());
                } else {
                    widget = (EditBox)this.m_7787_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ - 85, y, info.width, 20, null));
                    widget.m_94144_(info.tempValue);
                    Predicate processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.m_94153_(processor);
                    processor.test(info.tempValue);
                    this.m_7787_((GuiEventListener)widget);
                }
                y += 30;
            }
        }

        public void m_88315_(GuiGraphics helper, int mouseX, int mouseY, float delta) {
            if (mouseY >= 40 && mouseY <= 39 + entries.size() * 30) {
                int low = (mouseY - 10) / 30 * 30 + 10 + 2;
                helper.m_280509_(0, low, this.f_96543_, low + 30 - 4, 0x33FFFFFF);
            }
            super.m_88315_(helper, mouseX, mouseY, delta);
            helper.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
            int y = 40;
            for (EntryInfo info : entries) {
                helper.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)info.comment), 12, y + 10, 0xFFFFFF);
                y += 30;
            }
        }
    }
}

