/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.AdvancementPlugin;
import com.fren_gor.ultimateAdvancementAPI.database.impl.InMemory;
import com.fren_gor.ultimateAdvancementAPI.database.impl.MySQL;
import com.fren_gor.ultimateAdvancementAPI.database.impl.SQLite;
import com.fren_gor.ultimateAdvancementAPI.libs.net.byteflux.libby.Library;
import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    public static final int CONFIG_VERSION = 2;
    public static final Library CONFIG_UPDATER = Library.builder().groupId("com.tchristofferson").artifactId("ConfigUpdater").version("2.2").checksum("3LHINAggl0kkNC3nROgEWBXVu0aiFlofmFjq5aNAi3A=").build();
    private final File configFile;
    private final AdvancementPlugin plugin;
    private final YamlConfiguration config = new YamlConfiguration();
    private boolean disableVanillaAdvancements;
    private boolean disableVanillaRecipeAdvancements;
    private DB_TYPE storageType;
    private String sqlLiteDbName;
    private String username;
    private String password;
    private String databaseName;
    private String host;
    private int port;
    private int poolSize;
    private long connectionTimeout;

    public ConfigManager(@NotNull AdvancementPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin is null.");
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
    }

    public boolean loadVariables() {
        try {
            this.loadAndUpdateConfig();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load configuration", e);
            return true;
        }
        this.disableVanillaAdvancements = this.getOrDefault("disable-vanilla-advancements", false);
        this.disableVanillaRecipeAdvancements = this.getOrDefault("disable-vanilla-recipe-advancements", false);
        String type = this.config.getString("storage-type");
        if (type == null) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not find \"storage-type\" in config.yml");
            return true;
        }
        if (type.equalsIgnoreCase("SQLite")) {
            this.storageType = DB_TYPE.SQLITE;
            this.sqlLiteDbName = this.getOrDefault("sqlite.file", "database.db");
        } else if (type.equalsIgnoreCase("MySQL")) {
            this.storageType = DB_TYPE.MYSQL;
            this.username = this.getOrDefault("mysql.username", "root");
            this.password = this.getOrDefault("mysql.password", "");
            this.databaseName = this.getOrDefault("mysql.databaseName", "advancements");
            this.host = this.getOrDefault("mysql.host", "127.0.0.1");
            this.port = this.getOrDefault("mysql.port", 3306);
            this.poolSize = this.getOrDefault("mysql.advanced-settings.poolSize", 5);
            this.connectionTimeout = this.getOrDefault("mysql.advanced-settings.connectionTimeout", 6000L);
        } else if (type.equalsIgnoreCase("InMemory")) {
            this.storageType = DB_TYPE.IN_MEMORY;
        } else {
            this.plugin.getLogger().log(Level.SEVERE, "Invalid storage type \"" + type + "\"");
            return true;
        }
        return false;
    }

    public void saveDefault(boolean replace) {
        if (!this.configFile.exists() || replace) {
            this.plugin.saveResource("config.yml", replace);
        }
    }

    public void enable(@NotNull AdvancementMain main) {
        Preconditions.checkNotNull((Object)((Object)this.storageType), (Object)"Config has not been loaded.");
        main.enable(() -> switch (this.storageType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new SQLite(main, new File(this.plugin.getDataFolder(), this.sqlLiteDbName));
            case 1 -> new MySQL(main, this.username, this.password, this.databaseName, this.host, this.port, this.poolSize, this.connectionTimeout);
            case 2 -> new InMemory(main);
        });
    }

    private String getOrDefault(@NotNull String path, @NotNull String def) {
        String s;
        Object object = this.config.get(path);
        return object instanceof String ? (s = (String)object) : def;
    }

    private Boolean getOrDefault(@NotNull String path, @NotNull Boolean def) {
        Boolean b;
        Object object = this.config.get(path);
        return object instanceof Boolean ? (b = (Boolean)object) : def;
    }

    private Integer getOrDefault(@NotNull String path, @NotNull Integer def) {
        Integer i;
        Object object = this.config.get(path);
        return object instanceof Integer ? (i = (Integer)object) : def;
    }

    private Long getOrDefault(@NotNull String path, @NotNull Long def) {
        Long l;
        Object object = this.config.get(path);
        return object instanceof Long ? (l = (Long)object) : def;
    }

    public boolean getDisableVanillaAdvancements() {
        return this.disableVanillaAdvancements;
    }

    public boolean getDisableVanillaRecipeAdvancements() {
        return this.disableVanillaRecipeAdvancements;
    }

    public DB_TYPE getStorageType() {
        return this.storageType;
    }

    private void loadAndUpdateConfig() throws Exception {
        this.loadConfig();
        int configVersion = this.getOrDefault("config-version", -1);
        if (configVersion != 2) {
            try {
                this.config.set("config-version", null);
                this.config.save(this.configFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not remove config-version from the configuration file.", e);
            }
            try {
                this.updateConfig();
            }
            catch (Exception e) {
                try {
                    this.config.set("config-version", (Object)configVersion);
                    this.config.save(this.configFile);
                }
                catch (Exception ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not restore config-version to its previous value", ex);
                }
                throw new RuntimeException("Could not update the configuration file.", e);
            }
            this.loadConfig();
        }
    }

    private void loadConfig() {
        try {
            this.config.load(this.configFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load the configuration file.", e);
        }
    }

    private void updateConfig() throws Exception {
        Path path = this.plugin.getMain().getLibbyManager().downloadLibrary(CONFIG_UPDATER);
        try (URLClassLoader cl = new URLClassLoader(new URL[]{path.toUri().toURL()}, this.getClass().getClassLoader());){
            Class<?> updater = cl.loadClass("com.tchristofferson.configupdater.ConfigUpdater");
            Method updateMethod = updater.getDeclaredMethod("update", Plugin.class, String.class, File.class, List.class);
            updateMethod.invoke(null, new Object[]{this.plugin, "config.yml", this.configFile, List.of()});
        }
    }

    public static enum DB_TYPE {
        SQLITE("SQLite"),
        MYSQL("MySQL"),
        IN_MEMORY("In Memory");

        private final String fancyName;

        private DB_TYPE(String fancyName) {
            this.fancyName = Objects.requireNonNull(fancyName);
        }

        @NotNull
        public String getFancyName() {
            return this.fancyName;
        }
    }
}

