/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.commands.commandAPI_v9_3_0;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.commands.commandAPI_v9_3_0.AdvancementArgument;
import com.fren_gor.ultimateAdvancementAPI.commands.commandAPI_v9_3_0.AdvancementTabArgument;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.AbstractCommandAPICommand;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPI;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPICommand;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.arguments.AbstractArgument;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.arguments.Argument;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.arguments.BooleanArgument;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.arguments.EntitySelectorArgument;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.arguments.IntegerArgument;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.executors.ExecutorType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UltimateAdvancementAPICommand {
    private final AdvancementMain main;

    protected UltimateAdvancementAPICommand(@NotNull AdvancementMain main) {
        this.main = Objects.requireNonNull(main, "AdvancementMain is null.");
    }

    public void register() {
        CommandAPICommand mainCommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("ultimateadvancementapi").withPermission("ultimateadvancementapi.command")).withAliases(new String[]{"uladvapi", "uladv", "uaapi"})).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi <progression|grant|revoke> ..."), new ExecutorType[0]);
        CommandAPICommand grant = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("grant").withPermission("ultimateadvancementapi.grant")).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi grant <all|tab|one> ..."), new ExecutorType[0])).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{(CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("ultimateadvancementapi.grant.all")).executesPlayer((player, args) -> this.grantAll((CommandSender)player, player, true))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi grant all <player> [giveRewards]"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("ultimateadvancementapi.grant.all")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.grantAll(sender, (Collection)args.get("player"), true), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("ultimateadvancementapi.grant.all")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("player"), new BooleanArgument("giveRewards")})).executes((sender, args) -> this.grantAll(sender, (Collection)args.get("player"), (boolean)((Boolean)args.get("giveRewards"))), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.grant.tab")).executesPlayer((player, args) -> player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi grant tab <advancementTab> [player] [giveRewards]"))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi grant tab <advancementTab> <player> [giveRewards]"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.grant.tab")).withArguments((AbstractArgument[])new Argument[]{AdvancementTabArgument.getAdvancementTabArgument(this.main, "advancementTab")})).executesPlayer((player, args) -> this.grantTab((CommandSender)player, (AdvancementTab)args.get("advancementTab"), player, true)), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.grant.tab")).withArguments((AbstractArgument[])new Argument[]{AdvancementTabArgument.getAdvancementTabArgument(this.main, "advancementTab"), new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.grantTab(sender, (AdvancementTab)args.get("advancementTab"), (Collection)args.get("player"), true), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.grant.tab")).withArguments((AbstractArgument[])new Argument[]{AdvancementTabArgument.getAdvancementTabArgument(this.main, "advancementTab"), new EntitySelectorArgument.ManyPlayers("player"), new BooleanArgument("giveRewards")})).executes((sender, args) -> this.grantTab(sender, (AdvancementTab)args.get("advancementTab"), (Collection)args.get("player"), (boolean)((Boolean)args.get("giveRewards"))), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.grant.one")).executesPlayer((player, args) -> player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi grant one <advancement> [player] [giveRewards]"))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi grant one <advancement> <player> [giveRewards]"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.grant.one")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement")})).executesPlayer((player, args) -> this.grantOne((CommandSender)player, (Advancement)args.get("advancement"), player, true)), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.grant.one")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.grantOne(sender, (Advancement)args.get("advancement"), (Collection)args.get("player"), true), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.grant.one")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new EntitySelectorArgument.ManyPlayers("player"), new BooleanArgument("giveRewards")})).executes((sender, args) -> this.grantOne(sender, (Advancement)args.get("advancement"), (Collection)args.get("player"), (boolean)((Boolean)args.get("giveRewards"))), new ExecutorType[0])});
        CommandAPICommand revoke = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("revoke").withPermission("ultimateadvancementapi.revoke")).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi revoke <all|tab|one> ..."), new ExecutorType[0])).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{(CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("ultimateadvancementapi.revoke.all")).executesPlayer((player, args) -> this.revokeAll((CommandSender)player, player, false))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi revoke all <player> [hideTab]"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("ultimateadvancementapi.revoke.all")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.revokeAll(sender, (Collection)args.get("player"), false), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("ultimateadvancementapi.revoke.all")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("player"), new BooleanArgument("hideTabs")})).executes((sender, args) -> this.revokeAll(sender, (Collection)args.get("player"), (boolean)((Boolean)args.get("hideTabs"))), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.revoke.tab")).executesPlayer((player, args) -> player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi revoke tab <advancementTab> [player] [hideTab]"))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi revoke tab <advancementTab> <player> [hideTab]"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.revoke.tab")).withArguments((AbstractArgument[])new Argument[]{AdvancementTabArgument.getAdvancementTabArgument(this.main, "advancementTab")})).executesPlayer((player, args) -> this.revokeTab((CommandSender)player, (AdvancementTab)args.get("advancementTab"), player, false)), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.revoke.tab")).withArguments((AbstractArgument[])new Argument[]{AdvancementTabArgument.getAdvancementTabArgument(this.main, "advancementTab"), new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.revokeTab(sender, (AdvancementTab)args.get("advancementTab"), (Collection)args.get("player"), false), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tab").withPermission("ultimateadvancementapi.revoke.tab")).withArguments((AbstractArgument[])new Argument[]{AdvancementTabArgument.getAdvancementTabArgument(this.main, "advancementTab"), new EntitySelectorArgument.ManyPlayers("player"), new BooleanArgument("hideTab")})).executes((sender, args) -> this.revokeTab(sender, (AdvancementTab)args.get("advancementTab"), (Collection)args.get("player"), (boolean)((Boolean)args.get("hideTabs"))), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.revoke.one")).executesPlayer((player, args) -> player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi revoke one <advancement> [player]"))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi revoke one <advancement> <player>"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.revoke.one")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement")})).executesPlayer((player, args) -> this.revokeOne((CommandSender)player, (Advancement)args.get("advancement"), player)), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("one").withPermission("ultimateadvancementapi.revoke.one")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.revokeOne(sender, (Advancement)args.get("advancement"), (Collection)args.get("player")), new ExecutorType[0])});
        CommandAPICommand progression = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("progression").withPermission("ultimateadvancementapi.progression")).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi progression <get|set> ..."), new ExecutorType[0])).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{(CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("get").withPermission("ultimateadvancementapi.progression.get")).executesPlayer((player, args) -> player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi progression get <advancement> [player]"))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi progression get <advancement> <player>"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("get").withPermission("ultimateadvancementapi.progression.get")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement")})).executesPlayer((player, args) -> this.getProgression((CommandSender)player, (Advancement)args.get("advancement"), player)), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("get").withPermission("ultimateadvancementapi.progression.get")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.getProgression(sender, (Advancement)args.get("advancement"), (Collection)args.get("player")), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("set").withPermission("ultimateadvancementapi.progression.set")).executesPlayer((player, args) -> player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi progression set <advancement> <progression> [player] [giveRewards]"))).executes((sender, args) -> sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ultimateadvancementapi progression set <advancement> <progression> <player> [giveRewards]"), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("set").withPermission("ultimateadvancementapi.progression.set")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new IntegerArgument("progression", 0)})).executesPlayer((player, args) -> this.setProgression((CommandSender)player, (Advancement)args.get("advancement"), (int)((Integer)args.get("progression")), player, true)), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("set").withPermission("ultimateadvancementapi.progression.set")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new IntegerArgument("progression", 0), new EntitySelectorArgument.ManyPlayers("player")})).executes((sender, args) -> this.setProgression(sender, (Advancement)args.get("advancement"), (int)((Integer)args.get("progression")), (Collection)args.get("player"), true), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("set").withPermission("ultimateadvancementapi.progression.set")).withArguments((AbstractArgument[])new Argument[]{AdvancementArgument.getAdvancementArgument(this.main, "advancement"), new IntegerArgument("progression", 0), new EntitySelectorArgument.ManyPlayers("player"), new BooleanArgument("giveRewards")})).executes((sender, args) -> this.setProgression(sender, (Advancement)args.get("advancement"), (int)((Integer)args.get("progression")), (Collection)args.get("player"), (boolean)((Boolean)args.get("giveRewards"))), new ExecutorType[0])});
        mainCommand.withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{progression, grant, revoke});
        mainCommand.withHelp("Command to handle advancements.", "Command to grant/revoke/update player's advancements.");
        mainCommand.register();
    }

    private void grantAll(CommandSender sender, Player player, boolean giveRewards) throws WrapperCommandSyntaxException {
        this.grantAll(sender, List.of(player), giveRewards);
    }

    private void grantAll(CommandSender sender, Collection<Player> players, boolean giveRewards) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        for (AdvancementTab m : this.main.getTabs()) {
            if (!m.isActive()) continue;
            for (Advancement a2 : m.getAdvancements()) {
                for (Player p : players) {
                    a2.grant(p, giveRewards);
                }
            }
        }
        for (Player p : players) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancement has been unlocked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    private void grantTab(CommandSender sender, AdvancementTab tab, Player player, boolean giveRewards) throws WrapperCommandSyntaxException {
        this.grantTab(sender, tab, List.of(player), giveRewards);
    }

    private void grantTab(CommandSender sender, AdvancementTab tab, Collection<Player> players, boolean giveRewards) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        if (!tab.isActive()) {
            throw CommandAPI.failWithString((String)"Advancement tab is not active.");
        }
        for (Advancement a2 : tab.getAdvancements()) {
            for (Player p : players) {
                a2.grant(p, giveRewards);
            }
        }
        for (Player p : players) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancement of tab " + String.valueOf(ChatColor.YELLOW) + String.valueOf(tab) + String.valueOf(ChatColor.GREEN) + " has been unlocked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    private void grantOne(CommandSender sender, Advancement advancement, Player player, boolean giveRewards) throws WrapperCommandSyntaxException {
        this.grantOne(sender, advancement, List.of(player), giveRewards);
    }

    private void grantOne(CommandSender sender, Advancement advancement, Collection<Player> players, boolean giveRewards) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        for (Player p : players) {
            advancement.getAdvancementTab().showTab(p);
            advancement.grant(p, giveRewards);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Advancement " + String.valueOf(ChatColor.YELLOW) + String.valueOf(advancement.getKey()) + String.valueOf(ChatColor.GREEN) + " has been unlocked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    private void revokeAll(CommandSender sender, Player player, boolean hideTabs) throws WrapperCommandSyntaxException {
        this.revokeAll(sender, List.of(player), hideTabs);
    }

    private void revokeAll(CommandSender sender, Collection<Player> players, boolean hideTabs) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        for (AdvancementTab m : this.main.getTabs()) {
            Collection<Advancement> advancements = m.getAdvancements();
            for (Player p : players) {
                for (Advancement a2 : advancements) {
                    a2.revoke(p);
                }
                if (!hideTabs) continue;
                m.hideTab(p);
            }
        }
        for (Player p : players) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancement has been revoked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    private void revokeTab(CommandSender sender, AdvancementTab tab, Player player, boolean hideTab) throws WrapperCommandSyntaxException {
        this.revokeTab(sender, tab, List.of(player), hideTab);
    }

    private void revokeTab(CommandSender sender, AdvancementTab tab, Collection<Player> players, boolean hideTab) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        if (!tab.isActive()) {
            throw CommandAPI.failWithString((String)"Advancement tab is not active.");
        }
        Collection<Advancement> advancements = tab.getAdvancements();
        for (Player p : players) {
            for (Advancement a2 : advancements) {
                a2.revoke(p);
            }
            if (hideTab) {
                tab.hideTab(p);
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancement of tab " + String.valueOf(ChatColor.YELLOW) + String.valueOf(tab) + String.valueOf(ChatColor.GREEN) + " has been revoked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    private void revokeOne(CommandSender sender, Advancement advancement, Player player) throws WrapperCommandSyntaxException {
        this.revokeOne(sender, advancement, List.of(player));
    }

    private void revokeOne(CommandSender sender, Advancement advancement, Collection<Player> players) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        for (Player p : players) {
            advancement.revoke(p);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Advancement " + String.valueOf(ChatColor.YELLOW) + String.valueOf(advancement) + String.valueOf(ChatColor.GREEN) + " has been revoked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    private int getProgression(CommandSender sender, Advancement advancement, Player player) throws WrapperCommandSyntaxException {
        return this.getProgression(sender, advancement, List.of(player));
    }

    private int getProgression(CommandSender sender, Advancement advancement, Collection<Player> players) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        int progression = 0;
        for (Player p : players) {
            progression = advancement.getProgression(p);
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + p.getName() + String.valueOf(ChatColor.GREEN) + " progression is " + String.valueOf(ChatColor.YELLOW) + progression + "/" + advancement.getMaxProgression());
        }
        return progression;
    }

    private void setProgression(CommandSender sender, Advancement advancement, int progression, Player player, boolean giveRewards) throws WrapperCommandSyntaxException {
        this.setProgression(sender, advancement, progression, List.of(player), giveRewards);
    }

    private void setProgression(CommandSender sender, Advancement advancement, int progression, Collection<Player> players, boolean giveRewards) throws WrapperCommandSyntaxException {
        UltimateAdvancementAPICommand.validatePlayerArgument(players);
        for (Player p : players) {
            progression = Math.min(advancement.getMaxProgression(), progression);
            advancement.setProgression(p, progression, giveRewards);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + String.valueOf(ChatColor.YELLOW) + p.getName() + String.valueOf(ChatColor.GREEN) + " progression to " + String.valueOf(ChatColor.YELLOW) + progression + "/" + advancement.getMaxProgression());
        }
    }

    private static void validatePlayerArgument(@NotNull Collection<Player> players) throws WrapperCommandSyntaxException {
        if (players.size() == 0) {
            throw CommandAPI.failWithString((String)"No player has been provided.");
        }
    }
}

