/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.v1_21_R6.advancement;

import com.fren_gor.ultimateAdvancementAPI.nms.v1_21_R6.Util;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementWrapper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class AdvancementWrapper_v1_21_R6
extends AdvancementWrapper {
    private final AdvancementHolder advancementHolder;
    private final MinecraftKeyWrapper key;
    private final AdvancementWrapper parent;
    private final AdvancementDisplayWrapper display;

    public AdvancementWrapper_v1_21_R6(@NotNull MinecraftKeyWrapper key, @NotNull AdvancementDisplayWrapper display, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) {
        Map<String, Criterion<?>> advCriteria = Util.getAdvancementCriteria(maxProgression);
        Advancement advancement = new Advancement(Optional.empty(), Optional.of((DisplayInfo)display.toNMS()), AdvancementRewards.EMPTY, advCriteria, Util.getAdvancementRequirements(advCriteria), false, Optional.empty());
        this.advancementHolder = new AdvancementHolder((ResourceLocation)key.toNMS(), advancement);
        this.key = key;
        this.parent = null;
        this.display = display;
    }

    public AdvancementWrapper_v1_21_R6(@NotNull MinecraftKeyWrapper key, @NotNull AdvancementWrapper parent, @NotNull AdvancementDisplayWrapper display, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) {
        Map<String, Criterion<?>> advCriteria = Util.getAdvancementCriteria(maxProgression);
        Advancement advancement = new Advancement(Optional.of((ResourceLocation)parent.getKey().toNMS()), Optional.of((DisplayInfo)display.toNMS()), AdvancementRewards.EMPTY, advCriteria, Util.getAdvancementRequirements(advCriteria), false, Optional.empty());
        this.advancementHolder = new AdvancementHolder((ResourceLocation)key.toNMS(), advancement);
        this.key = key;
        this.parent = parent;
        this.display = display;
    }

    protected AdvancementWrapper_v1_21_R6(@NotNull MinecraftKeyWrapper key, @NotNull AdvancementDisplayWrapper display, @NotNull Map<String, Criterion<?>> advCriteria, @NotNull AdvancementRequirements advRequirements) {
        Advancement advancement = new Advancement(Optional.empty(), Optional.of((DisplayInfo)display.toNMS()), AdvancementRewards.EMPTY, advCriteria, advRequirements, false, Optional.empty());
        this.advancementHolder = new AdvancementHolder((ResourceLocation)key.toNMS(), advancement);
        this.key = key;
        this.parent = null;
        this.display = display;
    }

    protected AdvancementWrapper_v1_21_R6(@NotNull MinecraftKeyWrapper key, @NotNull AdvancementWrapper parent, @NotNull AdvancementDisplayWrapper display, @NotNull Map<String, Criterion<?>> advCriteria, @NotNull AdvancementRequirements advRequirements) {
        Advancement advancement = new Advancement(Optional.of((ResourceLocation)parent.getKey().toNMS()), Optional.of((DisplayInfo)display.toNMS()), AdvancementRewards.EMPTY, advCriteria, advRequirements, false, Optional.empty());
        this.advancementHolder = new AdvancementHolder((ResourceLocation)key.toNMS(), advancement);
        this.key = key;
        this.parent = parent;
        this.display = display;
    }

    @Override
    @NotNull
    public MinecraftKeyWrapper getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public AdvancementWrapper getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public AdvancementDisplayWrapper getDisplay() {
        return this.display;
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFL) int getMaxProgression() {
        return this.advancementHolder.value().requirements().size();
    }

    @NotNull
    public AdvancementHolder toNMS() {
        return this.advancementHolder;
    }
}

