/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.commands;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.commands.CommandAPIVersion;
import com.fren_gor.ultimateAdvancementAPI.libs.net.byteflux.libby.Library;
import com.fren_gor.ultimateAdvancementAPI.libs.net.byteflux.libby.LibraryManager;
import com.fren_gor.ultimateAdvancementAPI.util.Versions;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandAPIManager {
    public static final String PERMISSION_MAIN_COMMAND = "ultimateadvancementapi.command";
    public static final String PERMISSION_PROGRESSION = "ultimateadvancementapi.progression";
    public static final String PERMISSION_PROGRESSION_GET = "ultimateadvancementapi.progression.get";
    public static final String PERMISSION_PROGRESSION_SET = "ultimateadvancementapi.progression.set";
    public static final String PERMISSION_GRANT = "ultimateadvancementapi.grant";
    public static final String PERMISSION_GRANT_ALL = "ultimateadvancementapi.grant.all";
    public static final String PERMISSION_GRANT_TAB = "ultimateadvancementapi.grant.tab";
    public static final String PERMISSION_GRANT_ONE = "ultimateadvancementapi.grant.one";
    public static final String PERMISSION_REVOKE = "ultimateadvancementapi.revoke";
    public static final String PERMISSION_REVOKE_ALL = "ultimateadvancementapi.revoke.all";
    public static final String PERMISSION_REVOKE_TAB = "ultimateadvancementapi.revoke.tab";
    public static final String PERMISSION_REVOKE_ONE = "ultimateadvancementapi.revoke.one";

    @Nullable
    public static ILoadable loadManager(@NotNull LibraryManager libbyManager) {
        Class<?> clazz;
        Preconditions.checkNotNull((Object)libbyManager, (Object)"LibraryManager is null.");
        Optional<CommandAPIVersion> verOpt = Versions.getNMSVersion().map(CommandAPIVersion::getVersionToLoad);
        if (verOpt.isEmpty()) {
            return null;
        }
        CommandAPIVersion ver = verOpt.get();
        libbyManager.addMavenCentral();
        Library commandAPILibrary = Library.builder().groupId("dev{}jorel").artifactId(ver.getArtifactId()).version(ver.getVersion()).checksum(ver.getChecksum()).relocate("dev{}jorel{}commandapi", "com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi").build();
        try {
            libbyManager.loadLibrary(commandAPILibrary);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[UltimateAdvancementAPI-Commands] Can't load library " + commandAPILibrary.toString() + "!");
            e.printStackTrace();
            return null;
        }
        String manager = "com.fren_gor.ultimateAdvancementAPI.commands.commandAPI_v" + ver.getClasspathSuffix() + ".CommandAPIManager";
        try {
            clazz = Class.forName(manager);
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().info("[UltimateAdvancementAPI-Commands] Can't find CommandAPIManager Class! (" + manager + ")");
            e.printStackTrace();
            return null;
        }
        try {
            return new CommonLoadable((ILoadable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final class CommonLoadable
    implements ILoadable {
        private final ILoadable loadable;
        private JavaPlugin advancementMainOwner;
        private boolean enabled = false;

        public CommonLoadable(@NotNull ILoadable loadable) {
            Preconditions.checkNotNull((Object)loadable, (Object)"ILoadable is null.");
            this.loadable = loadable;
        }

        @Override
        public void onLoad(@NotNull AdvancementMain main, @NotNull JavaPlugin plugin) {
            Preconditions.checkNotNull((Object)plugin, (Object)"JavaPlugin is null.");
            Preconditions.checkArgument((plugin == main.getOwningPlugin() ? 1 : 0) != 0, (Object)"AdvancementMain owning plugin isn't the provided JavaPlugin.");
            Preconditions.checkArgument((boolean)AdvancementMain.isLoaded(), (Object)"AdvancementMain is not loaded.");
            this.advancementMainOwner = plugin;
            this.loadable.onLoad(main, plugin);
        }

        @Override
        public void onEnable() {
            if (this.advancementMainOwner == null) {
                throw new IllegalStateException("Not loaded.");
            }
            Preconditions.checkArgument((boolean)this.advancementMainOwner.isEnabled(), (Object)"Plugin is not enabled.");
            Preconditions.checkArgument((boolean)AdvancementMain.isEnabled(), (Object)"AdvancementMain is not enabled.");
            this.enabled = true;
            this.loadable.onEnable();
        }

        @Override
        public void onDisable() {
            if (this.advancementMainOwner == null) {
                throw new IllegalStateException("Not loaded and not enabled.");
            }
            if (!this.enabled) {
                throw new IllegalStateException("Not enabled.");
            }
            this.enabled = false;
            this.advancementMainOwner = null;
            this.loadable.onDisable();
        }
    }

    public static interface ILoadable {
        public void onLoad(@NotNull AdvancementMain var1, @NotNull JavaPlugin var2);

        public void onEnable();

        public void onDisable();
    }
}

